/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.service.impl;

import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.sca.message.ScaMessage;
import de.adorsys.ledgers.sca.service.ScaMessageResolver;
import de.adorsys.ledgers.sca.service.impl.message.EmailOtpMessageHandler;
import de.adorsys.ledgers.sca.service.impl.message.OtpMessageHandler;
import de.adorsys.ledgers.um.api.domain.ScaMethodTypeBO;
import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ScaMessageResolverImpl
implements ScaMessageResolver<ScaMessage> {
    private final List<OtpMessageHandler<? extends ScaMessage>> otpMessageHandlers;
    private final EmailOtpMessageHandler defaultOtpMessageHandler;

    public ScaMessage resolveMessage(AuthCodeDataBO data, ScaUserDataBO scaData, String tan) {
        return this.getOtpMessageHandler(scaData.getScaMethod()).getMessage(data, scaData, tan);
    }

    private OtpMessageHandler<? extends ScaMessage> getOtpMessageHandler(ScaMethodTypeBO methodType) {
        return this.otpMessageHandlers.stream().filter(h -> h.getType() == methodType).findFirst().orElse(this.defaultOtpMessageHandler);
    }

    public ScaMessageResolverImpl(List<OtpMessageHandler<? extends ScaMessage>> otpMessageHandlers, EmailOtpMessageHandler defaultOtpMessageHandler) {
        this.otpMessageHandlers = otpMessageHandlers;
        this.defaultOtpMessageHandler = defaultOtpMessageHandler;
    }
}

