/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.service.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.ledgers.sca.db.domain.AuthCodeStatus;
import de.adorsys.ledgers.sca.db.domain.OpType;
import de.adorsys.ledgers.sca.db.domain.SCAOperationEntity;
import de.adorsys.ledgers.sca.db.domain.ScaStatus;
import de.adorsys.ledgers.sca.db.repository.SCAOperationRepository;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaAuthConfirmationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.domain.ScaValidationBO;
import de.adorsys.ledgers.sca.domain.sca.message.ScaMessage;
import de.adorsys.ledgers.sca.service.AuthCodeGenerator;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.sca.service.SCASender;
import de.adorsys.ledgers.sca.service.ScaMessageResolver;
import de.adorsys.ledgers.sca.service.impl.ScaOperationValidationService;
import de.adorsys.ledgers.sca.service.impl.mapper.SCAOperationMapper;
import de.adorsys.ledgers.um.api.domain.ScaMethodTypeBO;
import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.exception.SCAErrorCode;
import de.adorsys.ledgers.util.exception.ScaModuleException;
import de.adorsys.ledgers.util.hash.BaseHashItem;
import de.adorsys.ledgers.util.hash.HashGenerationException;
import de.adorsys.ledgers.util.hash.HashGenerator;
import de.adorsys.ledgers.util.hash.HashGeneratorImpl;
import de.adorsys.ledgers.util.hash.HashItem;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class SCAOperationServiceImpl
implements SCAOperationService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SCAOperationServiceImpl.class);
    private static final String TAN_GENERATION_ERROR = "Could not generate TAN, Please contact your Bank Support";
    private static final String AUTH_CODE_GENERATION_ERROR = "TAN can't be generated, ERROR: {}";
    private final UserService userService;
    private final Environment env;
    private final SCAOperationRepository repository;
    private final AuthCodeGenerator authCodeGenerator;
    private final SCAOperationMapper scaOperationMapper;
    private final List<SCASender<? extends ScaMessage>> sendersList;
    private final ScaMessageResolver<?> messageResolver;
    private final ScaOperationValidationService validationService;
    private Map<ScaMethodTypeBO, SCASender> senders = new EnumMap<ScaMethodTypeBO, SCASender>(ScaMethodTypeBO.class);
    private HashGenerator hashGenerator = new HashGeneratorImpl();
    @Value(value="${ledgers.sca.authCode.validity.seconds:600}")
    private int authCodeValiditySeconds;
    @Value(value="${ledgers.sca.authCode.failed.max:5}")
    private int authCodeFailedMax;
    @Value(value="${ledgers.sca.login.failed.max:3}")
    private int loginFailedMax;
    @Value(value="${ledgers.sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;
    @Value(value="${ledgers.sca.authorisation_confirmation_enabled:false}")
    private boolean authConfirmationEnabled;

    public void afterPropertiesSet() {
        if (this.sendersList != null) {
            this.sendersList.forEach(s -> this.senders.put(s.getType(), (SCASender)s));
        }
    }

    public SCAOperationBO generateAuthCode(AuthCodeDataBO data, UserBO user, ScaStatusBO scaStatus) {
        SCAOperationEntity scaOperation = this.loadOrCreateScaOperation(data, scaStatus);
        this.validationService.checkValidityAndAttempts(scaOperation, data, user);
        scaOperation.setScaStatus(ScaStatus.valueOf((String)scaStatus.name()));
        ScaUserDataBO scaUserData = this.getScaUserData(user.getScaUserData(), scaOperation.getScaMethodId());
        this.checkMethodSupported(scaUserData);
        String tan = this.getTanDependingOnStrategy(scaUserData);
        String hash = this.generateHash(scaOperation.getId(), scaOperation.getOpId(), tan);
        scaOperation.updateStatusSent(this.authCodeValiditySeconds, hash, "SHA-256");
        this.repository.save((Object)scaOperation);
        if (scaUserData.getScaMethod() != ScaMethodTypeBO.EMAIL || scaUserData.isEmailValid()) {
            ScaMessage message = this.messageResolver.resolveMessage(data, scaUserData, tan);
            this.senders.get(scaUserData.getScaMethod()).send(message);
        }
        SCAOperationBO scaOperationBO = this.scaOperationMapper.toBO(scaOperation);
        scaOperationBO.setTan(tan);
        return scaOperationBO;
    }

    public ScaValidationBO validateAuthCode(String authorisationId, String opId, String authCode, int scaWeight) {
        SCAOperationEntity operation = (SCAOperationEntity)this.repository.findById((Object)authorisationId).orElseThrow(() -> ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_NOT_FOUND).devMsg("Sca operation does not contain SCA DATA").build());
        String authCodeHash = operation.getAuthCodeHash();
        this.validationService.checkAll(operation, opId);
        String generatedHash = this.generateHash(operation.getId(), opId, authCode);
        boolean isAuthCodeValid = StringUtils.equals((CharSequence)authCodeHash, (CharSequence)generatedHash);
        ScaValidationBO scaValidation = new ScaValidationBO(isAuthCodeValid);
        if (!isAuthCodeValid) {
            throw this.updateFailedCount(authorisationId, false);
        }
        this.success(operation, scaWeight, scaValidation);
        return scaValidation;
    }

    public void processExpiredOperations() {
        List operations = this.repository.findByStatus(AuthCodeStatus.SENT);
        log.info("{} operations with status NEW were found", (Object)operations.size());
        List<SCAOperationEntity> expiredOperations = operations.stream().filter(SCAOperationEntity::isOperationExpired).collect(Collectors.toList());
        expiredOperations.forEach(SCAOperationEntity::expireOperation);
        log.info("{} operations was detected as EXPIRED", (Object)expiredOperations.size());
        this.repository.saveAll(expiredOperations);
        log.info("Expired operations were updated");
    }

    public SCAOperationBO createAuthCode(AuthCodeDataBO authCodeData, ScaStatusBO scaStatus) {
        this.checkAuthIdPresent(authCodeData);
        return this.scaOperationMapper.toBO(this.createAuthCodeInternal(authCodeData, scaStatus));
    }

    public SCAOperationBO loadAuthCode(String authorizationId) {
        SCAOperationEntity o = (SCAOperationEntity)this.repository.findById((Object)authorizationId).orElseThrow(() -> ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_NOT_FOUND).devMsg(String.format("Sca operation for authorization %s not found", authorizationId)).build());
        return this.scaOperationMapper.toBO(o);
    }

    public boolean authenticationCompleted(String opId, OpTypeBO opType) {
        List found = this.repository.findByOpIdAndOpType(opId, OpType.valueOf((String)opType.name()));
        return this.multilevelScaEnable ? this.validationService.isMultiLevelScaCompleted(found, opType) : this.validationService.isAnyScaCompleted(found);
    }

    public ScaAuthConfirmationBO verifyAuthConfirmationCode(String authorisationId, String confirmationCode) {
        SCAOperationEntity entity = this.getScaOperationEntityByIdAndUnconfirmed(authorisationId);
        boolean isCodeConfirmValid = StringUtils.equals((CharSequence)entity.getAuthCodeHash(), (CharSequence)this.generateHash(authorisationId, null, confirmationCode));
        this.repository.save((Object)entity.updateStatuses(isCodeConfirmValid));
        return new ScaAuthConfirmationBO(isCodeConfirmValid, OpTypeBO.valueOf((String)entity.getOpType().name()), entity.getOpId());
    }

    public ScaAuthConfirmationBO completeAuthConfirmation(String authorisationId, boolean authCodeConfirmed) {
        SCAOperationEntity entity = this.getScaOperationEntityByIdAndUnconfirmed(authorisationId);
        this.repository.save((Object)entity.updateStatuses(authCodeConfirmed));
        return new ScaAuthConfirmationBO(authCodeConfirmed, OpTypeBO.valueOf((String)entity.getOpType().name()), entity.getOpId());
    }

    public SCAOperationBO checkIfExistsOrNew(AuthCodeDataBO data) {
        this.checkAuthIdPresent(data);
        Optional scaOperation = this.repository.findById((Object)data.getAuthorisationId());
        scaOperation.ifPresent(this.validationService::checksOnPresentOperation);
        return scaOperation.map(this.scaOperationMapper::toBO).orElseGet(() -> this.createAuthCode(data, ScaStatusBO.PSUAUTHENTICATED));
    }

    private void checkAuthIdPresent(AuthCodeDataBO data) {
        if (StringUtils.isBlank((CharSequence)data.getAuthorisationId())) {
            throw ScaModuleException.builder().errorCode(SCAErrorCode.AUTH_CODE_GENERATION_FAILURE).devMsg("Missing authorization id.").build();
        }
    }

    public ScaModuleException updateFailedCount(String authorisationId, boolean isLoginOperation) {
        SCAOperationEntity operationEntity = this.getScaOperationEntityById(authorisationId);
        operationEntity.fail(isLoginOperation, this.loginFailedMax, this.authCodeFailedMax);
        this.repository.save((Object)operationEntity);
        return ScaModuleException.buildAttemptsException((int)(this.loginFailedMax - operationEntity.getFailledCount()), (boolean)isLoginOperation);
    }

    private SCAOperationEntity getScaOperationEntityByIdAndUnconfirmed(String authorisationId) {
        return (SCAOperationEntity)this.repository.findByIdAndScaStatus(authorisationId, ScaStatus.UNCONFIRMED).orElseThrow(() -> ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_NOT_FOUND).devMsg(String.format("Sca operation for authorisation %s not found", authorisationId)).build());
    }

    private SCAOperationEntity getScaOperationEntityById(String authorisationId) {
        return (SCAOperationEntity)this.repository.findById((Object)authorisationId).orElseThrow(() -> ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_NOT_FOUND).devMsg(String.format("Sca operation for authorisation %s not found", authorisationId)).build());
    }

    private String getTanDependingOnStrategy(ScaUserDataBO scaUserData) {
        return Arrays.asList(this.env.getActiveProfiles()).contains("sandbox") && scaUserData.isUsesStaticTan() && StringUtils.isNotBlank((CharSequence)scaUserData.getStaticTan()) ? scaUserData.getStaticTan() : this.authCodeGenerator.generate();
    }

    private void success(SCAOperationEntity operation, int scaWeight, ScaValidationBO scaValidation) {
        ScaStatus status = ScaStatus.FINALISED;
        if (this.authConfirmationEnabled) {
            status = ScaStatus.UNCONFIRMED;
            String confirmationCode = UUID.randomUUID().toString();
            operation.setAuthCodeHash(this.generateHash(operation.getId(), null, confirmationCode));
            scaValidation.setAuthConfirmationCode(confirmationCode);
        }
        scaValidation.setScaStatus(ScaStatusBO.valueOf((String)status.name()));
        operation.validate(status, scaWeight);
        this.repository.save((Object)operation);
    }

    private String generateHash(String id, String opId, String authCode) {
        String hash;
        try {
            hash = this.hashGenerator.hash((HashItem)new BaseHashItem((Object)new OperationHashItem(id, opId, authCode)));
        }
        catch (HashGenerationException e) {
            log.error(AUTH_CODE_GENERATION_ERROR, (Object)e.getMessage());
            throw ScaModuleException.builder().errorCode(SCAErrorCode.AUTH_CODE_GENERATION_FAILURE).devMsg(TAN_GENERATION_ERROR).build();
        }
        return hash;
    }

    private SCAOperationEntity createAuthCodeInternal(AuthCodeDataBO authCodeData, ScaStatusBO scaStatus) {
        SCAOperationEntity scaOp = new SCAOperationEntity(authCodeData.getAuthorisationId(), authCodeData.getOpId(), authCodeData.getExternalId(), OpType.valueOf((String)authCodeData.getOpType().name()), authCodeData.getScaUserDataId(), authCodeData.getValiditySeconds(), this.authCodeValiditySeconds, ScaStatus.valueOf((String)scaStatus.name()), authCodeData.getScaWeight());
        return (SCAOperationEntity)this.repository.save((Object)scaOp);
    }

    @NotNull
    private ScaUserDataBO getScaUserData(@NotNull List<ScaUserDataBO> scaUserData, String scaUserDataId) {
        return scaUserData.stream().filter(s -> scaUserDataId.equals(s.getId())).findFirst().map(this::mapToScaUserDataDecodingTan).orElseThrow(() -> ScaModuleException.builder().errorCode(SCAErrorCode.USER_SCA_DATA_NOT_FOUND).devMsg(String.format("Sca data not found for: %s", scaUserDataId)).build());
    }

    private ScaUserDataBO mapToScaUserDataDecodingTan(ScaUserDataBO data) {
        return new ScaUserDataBO(data.getId(), data.getScaMethod(), data.getMethodValue(), data.isUsesStaticTan(), this.userService.decodeStaticTan(data.getStaticTan()), data.isValid());
    }

    private SCAOperationEntity loadOrCreateScaOperation(AuthCodeDataBO data, ScaStatusBO scaStatus) {
        if (data.getAuthorisationId() == null) {
            throw ScaModuleException.builder().errorCode(SCAErrorCode.AUTH_CODE_GENERATION_FAILURE).devMsg("Missing authorization id.").build();
        }
        return this.repository.findById((Object)data.getAuthorisationId()).orElseGet(() -> this.createAuthCodeInternal(data, scaStatus));
    }

    private void checkMethodSupported(ScaUserDataBO scaMethod) {
        if (!this.senders.containsKey(scaMethod.getScaMethod())) {
            throw ScaModuleException.builder().errorCode(SCAErrorCode.SCA_METHOD_NOT_SUPPORTED).devMsg(String.format("SCA method %s is not supported", scaMethod.getScaMethod().name())).build();
        }
    }

    public void setSenders(Map<ScaMethodTypeBO, SCASender> senders) {
        this.senders = senders;
    }

    public void setHashGenerator(HashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public void setAuthCodeValiditySeconds(int authCodeValiditySeconds) {
        this.authCodeValiditySeconds = authCodeValiditySeconds;
    }

    public void setAuthCodeFailedMax(int authCodeFailedMax) {
        this.authCodeFailedMax = authCodeFailedMax;
    }

    public void setLoginFailedMax(int loginFailedMax) {
        this.loginFailedMax = loginFailedMax;
    }

    public void setMultilevelScaEnable(boolean multilevelScaEnable) {
        this.multilevelScaEnable = multilevelScaEnable;
    }

    public void setAuthConfirmationEnabled(boolean authConfirmationEnabled) {
        this.authConfirmationEnabled = authConfirmationEnabled;
    }

    public SCAOperationServiceImpl(UserService userService, Environment env, SCAOperationRepository repository, AuthCodeGenerator authCodeGenerator, SCAOperationMapper scaOperationMapper, List<SCASender<? extends ScaMessage>> sendersList, ScaMessageResolver<?> messageResolver, ScaOperationValidationService validationService) {
        this.userService = userService;
        this.env = env;
        this.repository = repository;
        this.authCodeGenerator = authCodeGenerator;
        this.scaOperationMapper = scaOperationMapper;
        this.sendersList = sendersList;
        this.messageResolver = messageResolver;
        this.validationService = validationService;
    }

    public static final class OperationHashItem {
        @JsonProperty
        private String id;
        @JsonProperty
        private String opId;
        @JsonProperty
        private String tan;

        public OperationHashItem(String id, String opId, String tan) {
            this.id = id;
            this.opId = opId;
            this.tan = tan;
        }
    }
}

