/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.service.impl.sender;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class EmailSender {
    private static final Logger log = LoggerFactory.getLogger(EmailSender.class);
    private final JavaMailSender sender;
    @Value(value="${ledgers.sca.authCode.email.subject}")
    private String subject;
    @Value(value="${ledgers.sca.authCode.email.from}")
    private String from;

    public boolean send(String value, String authCode) {
        log.info("Preparing an email to send auth code");
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setTo(value);
            message.setSubject(this.subject);
            message.setText(authCode);
            message.setFrom(this.from);
            this.sender.send(message);
        }
        catch (MailException e) {
            log.error("Error sending email, No SMTP service configured");
            log.error(e.getMessage());
            return false;
        }
        log.info("Auth code was successfully sent via email");
        return true;
    }

    void setSubject(String subject) {
        this.subject = subject;
    }

    void setFrom(String from) {
        this.from = from;
    }

    public EmailSender(JavaMailSender sender) {
        this.sender = sender;
    }
}

