/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.service.impl;

import de.adorsys.ledgers.sca.db.repository.RecoveryPointRepository;
import de.adorsys.ledgers.sca.domain.RecoveryPointBO;
import de.adorsys.ledgers.sca.service.RecoveryPointService;
import de.adorsys.ledgers.sca.service.impl.mapper.RecoveryPointMapper;
import de.adorsys.ledgers.util.exception.SCAErrorCode;
import de.adorsys.ledgers.util.exception.ScaModuleException;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecoveryPointServiceImpl
implements RecoveryPointService {
    private final RecoveryPointRepository repository;
    private final RecoveryPointMapper mapper;

    public RecoveryPointBO getById(long id, String branchId) {
        return this.repository.findByIdAndBranchId(id, branchId).map(this.mapper::toBO).orElseThrow(() -> ScaModuleException.builder().errorCode(SCAErrorCode.RECOVERY_POINT_NOT_FOUND).devMsg(String.format("Recovery point %s not found", id)).build());
    }

    public List<RecoveryPointBO> getAllByBranch(String branchId) {
        return this.mapper.toBOs(this.repository.findAllByBranchId(branchId));
    }

    @Transactional
    public void deleteRecoveryPoint(long id, String branchId) {
        if (!this.repository.existsByIdAndBranchId(id, branchId)) {
            throw ScaModuleException.builder().errorCode(SCAErrorCode.RECOVERY_POINT_NOT_FOUND).devMsg(String.format("Recovery point %s not found", id)).build();
        }
        this.repository.deleteById(id);
    }

    public void createRecoveryPoint(RecoveryPointBO recoveryPoint) {
        recoveryPoint.checkAndUpdateDescription();
        this.repository.save((Object)this.mapper.toEntity(recoveryPoint));
    }

    public RecoveryPointServiceImpl(RecoveryPointRepository repository, RecoveryPointMapper mapper) {
        this.repository = repository;
        this.mapper = mapper;
    }
}

