/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.service.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.ledgers.sca.db.domain.AuthCodeStatus;
import de.adorsys.ledgers.sca.db.domain.OpType;
import de.adorsys.ledgers.sca.db.domain.SCAOperationEntity;
import de.adorsys.ledgers.sca.db.domain.ScaStatus;
import de.adorsys.ledgers.sca.db.repository.SCAOperationRepository;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaAuthConfirmationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.domain.ScaValidationBO;
import de.adorsys.ledgers.sca.service.AuthCodeGenerator;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.sca.service.SCASender;
import de.adorsys.ledgers.sca.service.impl.mapper.SCAOperationMapper;
import de.adorsys.ledgers.um.api.domain.ScaMethodTypeBO;
import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.util.exception.SCAErrorCode;
import de.adorsys.ledgers.util.exception.ScaModuleException;
import de.adorsys.ledgers.util.hash.BaseHashItem;
import de.adorsys.ledgers.util.hash.HashGenerationException;
import de.adorsys.ledgers.util.hash.HashGenerator;
import de.adorsys.ledgers.util.hash.HashGeneratorImpl;
import de.adorsys.ledgers.util.hash.HashItem;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class SCAOperationServiceImpl
implements SCAOperationService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SCAOperationServiceImpl.class);
    private static final String TAN_VALIDATION_ERROR = "Can't validate client TAN";
    private static final String AUTH_CODE_GENERATION_ERROR = "TAN can't be generated";
    private static final String STOLEN_ERROR = "Seems auth code was stolen because it already used in the system";
    private static final String EXPIRATION_ERROR = "Operation is not valid because of expiration";
    private final Environment env;
    private final SCAOperationRepository repository;
    private final AuthCodeGenerator authCodeGenerator;
    private final SCAOperationMapper scaOperationMapper;
    private final List<SCASender> sendersList;
    private Map<ScaMethodTypeBO, SCASender> senders = new EnumMap<ScaMethodTypeBO, SCASender>(ScaMethodTypeBO.class);
    private HashGenerator hashGenerator = new HashGeneratorImpl();
    @Value(value="${default.token.lifetime.seconds:600}")
    private int authCodeValiditySeconds;
    @Value(value="${sca.authCode.email.body}")
    private String authCodeEmailBody;
    @Value(value="${sca.authCode.failed.max:5}")
    private int authCodeFailedMax;
    @Value(value="${sca.login.failed.max:3}")
    private int loginFailedMax;
    @Value(value="${sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;
    @Value(value="${sca.final.weight:100}")
    private int finalWeight;
    @Value(value="${sca.authorisation_confirmation_enabled:false}")
    private boolean authConfirmationEnabled;

    public void afterPropertiesSet() {
        if (this.sendersList != null) {
            this.sendersList.forEach(s -> this.senders.put(s.getType(), (SCASender)s));
        }
    }

    public SCAOperationBO generateAuthCode(AuthCodeDataBO data, UserBO user, ScaStatusBO scaStatus) {
        SCAOperationEntity scaOperation = this.loadOrCreateScaOperation(data, scaStatus);
        this.checkOperationAttempts(scaOperation, false);
        this.checkScaOperationIsValid(data, user, scaOperation);
        scaOperation.setScaStatus(ScaStatus.valueOf((String)scaStatus.name()));
        ScaUserDataBO scaUserData = this.getScaUserData(user.getScaUserData(), scaOperation.getScaMethodId());
        this.checkMethodSupported(scaUserData);
        String tan = this.getTanDependingOnStrategy(scaUserData);
        BaseHashItem hashItem = new BaseHashItem((Object)new OperationHashItem(scaOperation.getId(), scaOperation.getOpId(), data.getOpData(), tan));
        this.updateSCAOperation(scaOperation, (BaseHashItem<OperationHashItem>)hashItem);
        this.repository.save((Object)scaOperation);
        if (scaUserData.isEmailValid()) {
            String userMessageTemplate = StringUtils.isBlank((CharSequence)data.getUserMessage()) ? this.authCodeEmailBody : data.getUserMessage();
            String message = String.format(userMessageTemplate, tan);
            this.senders.get(scaUserData.getScaMethod()).send(scaUserData.getMethodValue(), message);
        }
        SCAOperationBO scaOperationBO = this.scaOperationMapper.toBO(scaOperation);
        scaOperationBO.setTan(tan);
        return scaOperationBO;
    }

    public ScaValidationBO validateAuthCode(String authorisationId, String opId, String opData, String authCode, int scaWeight) {
        SCAOperationEntity operation = (SCAOperationEntity)this.repository.findById((Object)authorisationId).orElseThrow(() -> ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_NOT_FOUND).devMsg("Sca operation does not contain SCA DATA").build());
        String authCodeHash = operation.getAuthCodeHash();
        this.checkOperationAttempts(operation, false);
        this.checkOperationNotUsed(operation);
        this.checkOperationNotExpired(operation);
        this.checkSameOperation(operation, opId);
        String generatedHash = this.generateHash(operation.getId(), opId, opData, authCode);
        boolean isAuthCodeValid = StringUtils.equals((CharSequence)authCodeHash, (CharSequence)generatedHash);
        ScaValidationBO scaValidation = new ScaValidationBO(isAuthCodeValid);
        if (!isAuthCodeValid) {
            throw this.updateFailedCount(authorisationId, false);
        }
        this.success(operation, scaWeight, scaValidation);
        return scaValidation;
    }

    public void processExpiredOperations() {
        List operations = this.repository.findByStatus(AuthCodeStatus.SENT);
        log.info("{} operations with status NEW were found", (Object)operations.size());
        List<SCAOperationEntity> expiredOperations = operations.stream().filter(this::isOperationAlreadyExpired).collect(Collectors.toList());
        expiredOperations.forEach(o -> this.updateOperationStatus((SCAOperationEntity)o, AuthCodeStatus.EXPIRED, o.getScaStatus(), 0));
        log.info("{} operations was detected as EXPIRED", (Object)expiredOperations.size());
        this.repository.saveAll(expiredOperations);
        log.info("Expired operations were updated");
    }

    public SCAOperationBO createAuthCode(AuthCodeDataBO authCodeData, ScaStatusBO scaStatus) {
        return this.scaOperationMapper.toBO(this.createAuthCodeInternal(authCodeData, scaStatus));
    }

    public SCAOperationBO loadAuthCode(String authorizationId) {
        SCAOperationEntity o = (SCAOperationEntity)this.repository.findById((Object)authorizationId).orElseThrow(() -> ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_NOT_FOUND).devMsg(String.format("Sca operation for authorization %s not found", authorizationId)).build());
        return this.scaOperationMapper.toBO(o);
    }

    public boolean authenticationCompleted(String opId, OpTypeBO opType) {
        List found = this.repository.findByOpIdAndOpType(opId, OpType.valueOf((String)opType.name()));
        return this.multilevelScaEnable ? this.isMultiLevelScaCompleted(found, opType) : this.isAnyScaCompleted(found);
    }

    public ScaAuthConfirmationBO verifyAuthConfirmationCode(String authorisationId, String confirmationCode) {
        SCAOperationEntity entity = this.getScaOperationEntityByIdAndUnconfirmed(authorisationId);
        boolean isCodeConfirmValid = StringUtils.equals((CharSequence)entity.getAuthCodeHash(), (CharSequence)this.generateHash(authorisationId, confirmationCode));
        this.repository.save((Object)entity.updateStatuses(isCodeConfirmValid));
        return new ScaAuthConfirmationBO(isCodeConfirmValid, OpTypeBO.valueOf((String)entity.getOpType().name()), entity.getOpId());
    }

    public ScaAuthConfirmationBO completeAuthConfirmation(String authorisationId, boolean authCodeConfirmed) {
        SCAOperationEntity entity = this.getScaOperationEntityByIdAndUnconfirmed(authorisationId);
        this.repository.save((Object)entity.updateStatuses(authCodeConfirmed));
        return new ScaAuthConfirmationBO(authCodeConfirmed, OpTypeBO.valueOf((String)entity.getOpType().name()), entity.getOpId());
    }

    public SCAOperationBO checkIfExistsOrNew(AuthCodeDataBO data) {
        Optional scaOperation = this.repository.findById((Object)data.getAuthorisationId());
        scaOperation.ifPresent(o -> {
            this.checkOperationAttempts((SCAOperationEntity)o, true);
            this.checkOperationNotExpired((SCAOperationEntity)o);
            this.checkOperationNotUsed((SCAOperationEntity)o);
        });
        return scaOperation.map(this.scaOperationMapper::toBO).orElseGet(() -> this.createAuthCode(data, ScaStatusBO.RECEIVED));
    }

    private void checkOperationAttempts(SCAOperationEntity operation, boolean isLoginOperation) {
        int max;
        int n = max = isLoginOperation ? this.loginFailedMax : this.authCodeFailedMax;
        if (operation.getFailledCount() >= max) {
            throw ScaModuleException.buildAttemptsException((int)0, (boolean)isLoginOperation);
        }
    }

    public ScaModuleException updateFailedCount(String authorisationId, boolean isLoginOperation) {
        SCAOperationEntity operationEntity = this.getScaOperationEntityById(authorisationId);
        this.failed(operationEntity, isLoginOperation);
        this.repository.save((Object)operationEntity);
        return ScaModuleException.buildAttemptsException((int)(this.loginFailedMax - operationEntity.getFailledCount()), (boolean)isLoginOperation);
    }

    private SCAOperationEntity getScaOperationEntityByIdAndUnconfirmed(String authorisationId) {
        return (SCAOperationEntity)this.repository.findByIdAndScaStatus(authorisationId, ScaStatus.UNCONFIRMED).orElseThrow(() -> ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_NOT_FOUND).devMsg(String.format("Sca operation for authorisation %s not found", authorisationId)).build());
    }

    private SCAOperationEntity getScaOperationEntityById(String authorisationId) {
        return (SCAOperationEntity)this.repository.findById((Object)authorisationId).orElseThrow(() -> ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_NOT_FOUND).devMsg(String.format("Sca operation for authorisation %s not found", authorisationId)).build());
    }

    private String getTanDependingOnStrategy(ScaUserDataBO scaUserData) {
        return Arrays.asList(this.env.getActiveProfiles()).contains("sandbox") && scaUserData.isUsesStaticTan() && StringUtils.isNotBlank((CharSequence)scaUserData.getStaticTan()) ? scaUserData.getStaticTan() : this.authCodeGenerator.generate();
    }

    private void checkScaOperationIsValid(AuthCodeDataBO data, UserBO user, SCAOperationEntity scaOperation) {
        if (scaOperation.getScaMethodId() == null) {
            if (data.getScaUserDataId() == null) {
                throw ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_VALIDATION_INVALID).devMsg("Missing selected sca method.").build();
            }
            scaOperation.setScaMethodId(data.getScaUserDataId());
        }
        if (CollectionUtils.isEmpty((Collection)user.getScaUserData())) {
            throw ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_VALIDATION_INVALID).devMsg(String.format("User with login %s has no sca data", user.getLogin())).build();
        }
    }

    private boolean isMultiLevelScaCompleted(List<SCAOperationEntity> found, OpTypeBO opType) {
        return EnumSet.of(OpTypeBO.PAYMENT, OpTypeBO.CANCEL_PAYMENT, OpTypeBO.CONSENT).contains(opType) && this.isCompletedByAllUsers(found);
    }

    private boolean isCompletedByAllUsers(List<SCAOperationEntity> found) {
        return found.stream().filter(op -> op.getScaStatus() == ScaStatus.FINALISED).collect(Collectors.summarizingInt(SCAOperationEntity::getScaWeight)).getSum() >= (long)this.finalWeight;
    }

    private boolean isAnyScaCompleted(List<SCAOperationEntity> found) {
        return found.stream().anyMatch(op -> op.getScaStatus() == ScaStatus.FINALISED);
    }

    private void success(SCAOperationEntity operation, int scaWeight, ScaValidationBO scaValidation) {
        ScaStatus status = ScaStatus.FINALISED;
        if (this.authConfirmationEnabled) {
            status = ScaStatus.UNCONFIRMED;
            String confirmationCode = UUID.randomUUID().toString();
            operation.setAuthCodeHash(this.generateHash(operation.getId(), confirmationCode));
            scaValidation.setAuthConfirmationCode(confirmationCode);
        }
        scaValidation.setScaStatus(ScaStatusBO.valueOf((String)status.name()));
        this.updateOperationStatus(operation, AuthCodeStatus.VALIDATED, status, scaWeight);
        this.repository.save((Object)operation);
    }

    private void failed(SCAOperationEntity operation, boolean isLoginOperation) {
        int failedMax;
        operation.setFailledCount(operation.getFailledCount() + 1);
        operation.setStatus(AuthCodeStatus.FAILED);
        int n = failedMax = isLoginOperation ? this.loginFailedMax : this.authCodeFailedMax;
        if (operation.getFailledCount() >= failedMax) {
            operation.setScaStatus(ScaStatus.FAILED);
        }
        operation.setStatusTime(LocalDateTime.now());
    }

    private void checkSameOperation(SCAOperationEntity operation, String opId) {
        if (!StringUtils.equals((CharSequence)opId, (CharSequence)operation.getOpId())) {
            throw ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_VALIDATION_INVALID).devMsg("Operation id not matching.").build();
        }
    }

    private String generateHash(String id, String confirmationCode) {
        return this.generateHash(id, null, null, confirmationCode);
    }

    private String generateHash(String id, String opId, String opData, String authCode) {
        String hash;
        try {
            hash = this.hashGenerator.hash((HashItem)new BaseHashItem((Object)new OperationHashItem(id, opId, opData, authCode)));
        }
        catch (HashGenerationException e) {
            log.error(TAN_VALIDATION_ERROR);
            throw ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_VALIDATION_INVALID).devMsg(TAN_VALIDATION_ERROR).build();
        }
        return hash;
    }

    private void checkOperationNotExpired(SCAOperationEntity operation) {
        if (this.isOperationAlreadyExpired(operation)) {
            this.updateOperationStatus(operation, AuthCodeStatus.EXPIRED, operation.getScaStatus(), 0);
            this.repository.save((Object)operation);
            log.error(EXPIRATION_ERROR);
            throw ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_EXPIRED).devMsg(EXPIRATION_ERROR).build();
        }
    }

    private void checkOperationNotUsed(SCAOperationEntity operation) {
        if (this.isOperationAlreadyUsed(operation)) {
            log.error(STOLEN_ERROR);
            throw ScaModuleException.builder().errorCode(SCAErrorCode.SCA_OPERATION_USED_OR_STOLEN).devMsg(STOLEN_ERROR).build();
        }
    }

    private SCAOperationEntity createAuthCodeInternal(AuthCodeDataBO authCodeData, ScaStatusBO scaStatus) {
        if (authCodeData.getAuthorisationId() == null) {
            throw ScaModuleException.builder().errorCode(SCAErrorCode.AUTH_CODE_GENERATION_FAILURE).devMsg("Missing authorization id.").build();
        }
        SCAOperationEntity scaOp = new SCAOperationEntity();
        scaOp.setId(authCodeData.getAuthorisationId());
        scaOp.setOpId(authCodeData.getOpId());
        scaOp.setOpType(OpType.valueOf((String)authCodeData.getOpType().name()));
        scaOp.setScaMethodId(authCodeData.getScaUserDataId());
        scaOp.setStatus(AuthCodeStatus.INITIATED);
        scaOp.setStatusTime(LocalDateTime.now());
        int validitySeconds = authCodeData.getValiditySeconds() <= 0 ? this.authCodeValiditySeconds : authCodeData.getValiditySeconds();
        scaOp.setValiditySeconds(validitySeconds);
        scaOp.setScaStatus(ScaStatus.valueOf((String)scaStatus.name()));
        scaOp.setScaWeight(authCodeData.getScaWeight());
        return (SCAOperationEntity)this.repository.save((Object)scaOp);
    }

    @NotNull
    private ScaUserDataBO getScaUserData(@NotNull List<ScaUserDataBO> scaUserData, @NotNull String scaUserDataId) {
        return scaUserData.stream().filter(s -> scaUserDataId.equals(s.getId())).findFirst().orElseThrow(() -> ScaModuleException.builder().errorCode(SCAErrorCode.USER_SCA_DATA_NOT_FOUND).devMsg(String.format("Sca data not found for: %s", scaUserDataId)).build());
    }

    private void updateSCAOperation(SCAOperationEntity scaOperation, BaseHashItem<OperationHashItem> hashItem) {
        String authCodeHash = this.generateHashByOpData(hashItem);
        scaOperation.setCreated(LocalDateTime.now());
        int validitySeconds = scaOperation.getValiditySeconds() <= 0 ? this.authCodeValiditySeconds : scaOperation.getValiditySeconds();
        scaOperation.setValiditySeconds(validitySeconds);
        scaOperation.setStatus(AuthCodeStatus.SENT);
        scaOperation.setStatusTime(LocalDateTime.now());
        scaOperation.setHashAlg(hashItem.getAlg());
        scaOperation.setAuthCodeHash(authCodeHash);
    }

    private String generateHashByOpData(BaseHashItem<OperationHashItem> hashItem) {
        String authCodeHash;
        try {
            authCodeHash = this.hashGenerator.hash(hashItem);
        }
        catch (HashGenerationException e) {
            log.error(AUTH_CODE_GENERATION_ERROR);
            throw ScaModuleException.builder().errorCode(SCAErrorCode.AUTH_CODE_GENERATION_FAILURE).devMsg(AUTH_CODE_GENERATION_ERROR).build();
        }
        return authCodeHash;
    }

    private SCAOperationEntity loadOrCreateScaOperation(AuthCodeDataBO data, ScaStatusBO scaStatus) {
        if (data.getAuthorisationId() == null) {
            throw ScaModuleException.builder().errorCode(SCAErrorCode.AUTH_CODE_GENERATION_FAILURE).devMsg("Missing authorization id.").build();
        }
        return this.repository.findById((Object)data.getAuthorisationId()).orElseGet(() -> this.createAuthCodeInternal(data, scaStatus));
    }

    private void checkMethodSupported(ScaUserDataBO scaMethod) {
        if (!this.senders.containsKey(scaMethod.getScaMethod())) {
            throw ScaModuleException.builder().errorCode(SCAErrorCode.SCA_METHOD_NOT_SUPPORTED).devMsg(String.format("SCA method %s is not supported", scaMethod.getScaMethod().name())).build();
        }
    }

    private boolean isOperationAlreadyUsed(SCAOperationEntity operation) {
        return EnumSet.of(AuthCodeStatus.VALIDATED, AuthCodeStatus.EXPIRED, AuthCodeStatus.DONE).contains(operation.getStatus()) || EnumSet.of(ScaStatus.FAILED, ScaStatus.FINALISED).contains(operation.getScaStatus());
    }

    private boolean isOperationAlreadyExpired(SCAOperationEntity operation) {
        boolean hasExpiredStatus = operation.getStatus() == AuthCodeStatus.EXPIRED;
        int validitySeconds = operation.getValiditySeconds();
        return hasExpiredStatus || LocalDateTime.now().isAfter(operation.getCreated().plusSeconds(validitySeconds));
    }

    private void updateOperationStatus(SCAOperationEntity operation, AuthCodeStatus status, ScaStatus scaStatus, int scaWeight) {
        operation.setScaWeight(scaWeight);
        operation.setStatus(status);
        operation.setScaStatus(scaStatus);
        operation.setStatusTime(LocalDateTime.now());
    }

    public void setSenders(Map<ScaMethodTypeBO, SCASender> senders) {
        this.senders = senders;
    }

    public void setHashGenerator(HashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public void setAuthCodeValiditySeconds(int authCodeValiditySeconds) {
        this.authCodeValiditySeconds = authCodeValiditySeconds;
    }

    public void setAuthCodeEmailBody(String authCodeEmailBody) {
        this.authCodeEmailBody = authCodeEmailBody;
    }

    public void setAuthCodeFailedMax(int authCodeFailedMax) {
        this.authCodeFailedMax = authCodeFailedMax;
    }

    public void setLoginFailedMax(int loginFailedMax) {
        this.loginFailedMax = loginFailedMax;
    }

    public void setMultilevelScaEnable(boolean multilevelScaEnable) {
        this.multilevelScaEnable = multilevelScaEnable;
    }

    public void setFinalWeight(int finalWeight) {
        this.finalWeight = finalWeight;
    }

    public void setAuthConfirmationEnabled(boolean authConfirmationEnabled) {
        this.authConfirmationEnabled = authConfirmationEnabled;
    }

    public SCAOperationServiceImpl(Environment env, SCAOperationRepository repository, AuthCodeGenerator authCodeGenerator, SCAOperationMapper scaOperationMapper, List<SCASender> sendersList) {
        this.env = env;
        this.repository = repository;
        this.authCodeGenerator = authCodeGenerator;
        this.scaOperationMapper = scaOperationMapper;
        this.sendersList = sendersList;
    }

    private static final class OperationHashItem {
        @JsonProperty
        private String id;
        @JsonProperty
        private String opId;
        @JsonProperty
        private String opData;
        @JsonProperty
        private String tan;

        public OperationHashItem(String id, String opId, String opData, String tan) {
            this.id = id;
            this.opId = opId;
            this.opData = opData;
            this.tan = tan;
        }
    }
}

