/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.service.impl.mapper;

import de.adorsys.ledgers.sca.db.domain.SCAOperationEntity;
import de.adorsys.ledgers.sca.db.domain.ScaStatus;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.service.impl.mapper.SCAOperationMapper;
import org.springframework.stereotype.Component;

@Component
public class SCAOperationMapperImpl
implements SCAOperationMapper {
    @Override
    public SCAOperationBO toBO(SCAOperationEntity entity) {
        if (entity == null) {
            return null;
        }
        SCAOperationBO sCAOperationBO = new SCAOperationBO();
        sCAOperationBO.setId(entity.getId());
        sCAOperationBO.setOpId(entity.getOpId());
        sCAOperationBO.setValiditySeconds(entity.getValiditySeconds());
        sCAOperationBO.setAuthCodeHash(entity.getAuthCodeHash());
        sCAOperationBO.setStatus(this.toBO(entity.getStatus()));
        sCAOperationBO.setHashAlg(entity.getHashAlg());
        sCAOperationBO.setCreated(entity.getCreated());
        sCAOperationBO.setStatusTime(entity.getStatusTime());
        sCAOperationBO.setOpType(this.toBO(entity.getOpType()));
        sCAOperationBO.setScaMethodId(entity.getScaMethodId());
        sCAOperationBO.setFailledCount(entity.getFailledCount());
        sCAOperationBO.setScaStatus(this.scaStatusToScaStatusBO(entity.getScaStatus()));
        return sCAOperationBO;
    }

    protected ScaStatusBO scaStatusToScaStatusBO(ScaStatus scaStatus) {
        ScaStatusBO scaStatusBO;
        if (scaStatus == null) {
            return null;
        }
        switch (scaStatus) {
            case RECEIVED: {
                scaStatusBO = ScaStatusBO.RECEIVED;
                break;
            }
            case PSUIDENTIFIED: {
                scaStatusBO = ScaStatusBO.PSUIDENTIFIED;
                break;
            }
            case PSUAUTHENTICATED: {
                scaStatusBO = ScaStatusBO.PSUAUTHENTICATED;
                break;
            }
            case SCAMETHODSELECTED: {
                scaStatusBO = ScaStatusBO.SCAMETHODSELECTED;
                break;
            }
            case STARTED: {
                scaStatusBO = ScaStatusBO.STARTED;
                break;
            }
            case FINALISED: {
                scaStatusBO = ScaStatusBO.FINALISED;
                break;
            }
            case FAILED: {
                scaStatusBO = ScaStatusBO.FAILED;
                break;
            }
            case EXEMPTED: {
                scaStatusBO = ScaStatusBO.EXEMPTED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + scaStatus);
            }
        }
        return scaStatusBO;
    }
}

