/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.service.impl.sender;

import de.adorsys.ledgers.sca.service.SCASender;
import de.adorsys.ledgers.um.api.domain.ScaMethodTypeBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class MailSCASender
implements SCASender {
    private static final Logger logger = LoggerFactory.getLogger(MailSCASender.class);
    private final JavaMailSender sender;
    @Value(value="${sca.authCode.email.subject}")
    private String subject;
    @Value(value="${sca.authCode.email.from}")
    private String from;

    public MailSCASender(JavaMailSender sender) {
        this.sender = sender;
    }

    public boolean send(String value, String authCode) {
        logger.info("Preparing an email to send auth code");
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setTo(value);
            message.setSubject(this.subject);
            message.setText(authCode);
            message.setFrom(this.from);
            this.sender.send(message);
        }
        catch (MailException e) {
            logger.error("Error happens at sending email", (Throwable)e);
            return false;
        }
        logger.info("Auth code was successfully sent via email");
        return true;
    }

    public ScaMethodTypeBO getType() {
        return ScaMethodTypeBO.EMAIL;
    }

    void setSubject(String subject) {
        this.subject = subject;
    }

    void setFrom(String from) {
        this.from = from;
    }
}

