/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.service.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.ledgers.sca.db.domain.AuthCodeStatus;
import de.adorsys.ledgers.sca.db.domain.OpType;
import de.adorsys.ledgers.sca.db.domain.SCAOperationEntity;
import de.adorsys.ledgers.sca.db.domain.ScaStatus;
import de.adorsys.ledgers.sca.db.repository.SCAOperationRepository;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.exception.SCAMethodNotSupportedException;
import de.adorsys.ledgers.sca.exception.SCAOperationExpiredException;
import de.adorsys.ledgers.sca.exception.SCAOperationNotFoundException;
import de.adorsys.ledgers.sca.exception.SCAOperationUsedOrStolenException;
import de.adorsys.ledgers.sca.exception.SCAOperationValidationException;
import de.adorsys.ledgers.sca.exception.ScaUncheckedException;
import de.adorsys.ledgers.sca.service.AuthCodeGenerator;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.sca.service.SCASender;
import de.adorsys.ledgers.sca.service.impl.mapper.SCAOperationMapper;
import de.adorsys.ledgers.um.api.domain.ScaMethodTypeBO;
import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.exception.UserScaDataNotFoundException;
import de.adorsys.ledgers.util.hash.BaseHashItem;
import de.adorsys.ledgers.util.hash.HashGenerationException;
import de.adorsys.ledgers.util.hash.HashGenerator;
import de.adorsys.ledgers.util.hash.HashGeneratorImpl;
import de.adorsys.ledgers.util.hash.HashItem;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SCAOperationServiceImpl
implements SCAOperationService {
    private static final Logger logger = LoggerFactory.getLogger(SCAOperationServiceImpl.class);
    private static final String TAN_VALIDATION_ERROR = "Can't validate client TAN";
    private static final String AUTH_CODE_GENERATION_ERROR = "TAN can't be generated";
    private static final String STOLEN_ERROR = "Seems auth code was stolen because it already used in the system";
    private static final String EXPIRATION_ERROR = "Operation is not valid because of expiration";
    private final SCAOperationRepository repository;
    private final AuthCodeGenerator authCodeGenerator;
    private final SCAOperationMapper scaOperationMapper;
    private HashGenerator hashGenerator;
    private Map<ScaMethodTypeBO, SCASender> senders = new HashMap<ScaMethodTypeBO, SCASender>();
    @Value(value="${sca.authCode.validity.seconds:180}")
    private int authCodeValiditySeconds;
    @Value(value="${sca.authCode.email.body}")
    private String authCodeEmailBody;
    @Value(value="${sca.authCode.failed.max:5}")
    private int authCodeFailedMax;

    public SCAOperationServiceImpl(List<SCASender> senders, SCAOperationRepository repository, AuthCodeGenerator authCodeGenerator, SCAOperationMapper scaOperationMapper) {
        this.repository = repository;
        this.scaOperationMapper = scaOperationMapper;
        this.authCodeGenerator = authCodeGenerator;
        this.hashGenerator = new HashGeneratorImpl();
        if (senders != null) {
            senders.forEach(s -> this.senders.put(s.getType(), (SCASender)s));
        }
    }

    public SCAOperationBO generateAuthCode(AuthCodeDataBO data, UserBO user, ScaStatusBO scaStatus) throws SCAOperationValidationException, SCAMethodNotSupportedException, UserScaDataNotFoundException, SCAOperationNotFoundException {
        SCAOperationEntity scaOperation = this.loadOrCreateScaOperation(data, scaStatus);
        if (scaOperation.getScaMethodId() == null) {
            if (data.getScaUserDataId() == null) {
                throw new SCAOperationValidationException("Missing selected sca method.");
            }
            scaOperation.setScaMethodId(data.getScaUserDataId());
        }
        if (user.getScaUserData() == null) {
            throw new SCAOperationValidationException(String.format("User with login %s has no sca data", user.getLogin()));
        }
        if (scaStatus != null) {
            scaOperation.setScaStatus(ScaStatus.valueOf((String)scaStatus.name()));
        }
        ScaUserDataBO scaUserData = this.getScaUserData(user.getScaUserData(), scaOperation.getScaMethodId());
        this.checkMethodSupported(scaUserData);
        String tan = this.authCodeGenerator.generate();
        BaseHashItem hashItem = new BaseHashItem((Object)new OperationHashItem(scaOperation.getId(), scaOperation.getOpId(), data.getOpData(), tan));
        scaOperation = this.buildSCAOperation(scaOperation, (BaseHashItem<OperationHashItem>)hashItem);
        this.repository.save((Object)scaOperation);
        String usderMessageTemplate = StringUtils.isBlank((CharSequence)data.getUserMessage()) ? this.authCodeEmailBody : data.getUserMessage();
        String message = String.format(usderMessageTemplate, tan);
        this.senders.get(scaUserData.getScaMethod()).send(scaUserData.getMethodValue(), message);
        return this.scaOperationMapper.toBO(scaOperation);
    }

    public boolean validateAuthCode(String authorisationId, String opId, String opData, String authCode) throws SCAOperationNotFoundException, SCAOperationValidationException, SCAOperationUsedOrStolenException, SCAOperationExpiredException {
        boolean isAuthCodeValid;
        Optional operationOptional = this.repository.findById((Object)authorisationId);
        String authCodeHash = operationOptional.map(SCAOperationEntity::getAuthCodeHash).orElseThrow(SCAOperationNotFoundException::new);
        SCAOperationEntity operation = (SCAOperationEntity)operationOptional.get();
        this.checkOperationNotUsed(operation);
        this.checkOperationNotExpired(operation);
        this.checkSameOperation(operation, opId);
        String generatedHash = this.generateHash(operation.getId(), opId, opData, authCode);
        boolean bl = isAuthCodeValid = generatedHash != null && generatedHash.equals(authCodeHash);
        if (isAuthCodeValid) {
            this.success(operation);
        } else {
            this.failled(operation);
        }
        return isAuthCodeValid;
    }

    public void processExpiredOperations() {
        List operations = this.repository.findByStatus(AuthCodeStatus.SENT);
        logger.info("{} operations with status NEW were found", (Object)operations.size());
        List<SCAOperationEntity> expiredOperations = operations.stream().filter(this::isOperationAlreadyExpired).collect(Collectors.toList());
        expiredOperations.forEach(o -> this.updateOperationStatus((SCAOperationEntity)o, AuthCodeStatus.EXPIRED, o.getScaStatus()));
        logger.info("{} operations was detected as EXPIRED", (Object)expiredOperations.size());
        this.repository.saveAll(expiredOperations);
        logger.info("Expired operations were updated");
    }

    public SCAOperationBO createAuthCode(AuthCodeDataBO authCodeData, ScaStatusBO scaStatus) {
        return this.scaOperationMapper.toBO(this.createAuthCodeInternal(authCodeData, scaStatus));
    }

    public SCAOperationBO loadAuthCode(String authorizationId) throws SCAOperationNotFoundException {
        SCAOperationEntity o = (SCAOperationEntity)this.repository.findById((Object)authorizationId).orElseThrow(() -> new SCAOperationNotFoundException(authorizationId));
        return this.scaOperationMapper.toBO(o);
    }

    public boolean authenticationCompleted(String opId, OpTypeBO opType) {
        List found = this.repository.findByOpIdAndOpType(opId, OpType.valueOf((String)opType.name()));
        if (found.isEmpty()) {
            return false;
        }
        return found.stream().anyMatch(s -> s.getStatus().equals((Object)AuthCodeStatus.VALIDATED));
    }

    private void success(SCAOperationEntity operation) {
        this.updateOperationStatus(operation, AuthCodeStatus.VALIDATED, ScaStatus.FINALISED);
        this.repository.save((Object)operation);
    }

    private void failled(SCAOperationEntity operation) {
        operation.setFailledCount(operation.getFailledCount() + 1);
        operation.setStatus(AuthCodeStatus.FAILED);
        if (operation.getFailledCount() >= this.authCodeFailedMax) {
            operation.setScaStatus(ScaStatus.FAILED);
        }
        operation.setStatusTime(LocalDateTime.now());
        this.repository.save((Object)operation);
    }

    private void checkSameOperation(SCAOperationEntity operation, String opId) throws SCAOperationValidationException {
        if (!StringUtils.equals((CharSequence)opId, (CharSequence)operation.getOpId())) {
            throw new SCAOperationValidationException("Operation id not matching.");
        }
    }

    private String generateHash(String id, String opId, String opData, String authCode) throws SCAOperationValidationException {
        String hash;
        try {
            hash = this.hashGenerator.hash((HashItem)new BaseHashItem((Object)new OperationHashItem(id, opId, opData, authCode)));
        }
        catch (HashGenerationException e) {
            logger.error(TAN_VALIDATION_ERROR, (Throwable)e);
            throw new SCAOperationValidationException(TAN_VALIDATION_ERROR, (Throwable)e);
        }
        return hash;
    }

    private void checkOperationNotExpired(SCAOperationEntity operation) throws SCAOperationExpiredException {
        if (this.isOperationAlreadyExpired(operation)) {
            this.updateOperationStatus(operation, AuthCodeStatus.EXPIRED, operation.getScaStatus());
            this.repository.save((Object)operation);
            logger.error(EXPIRATION_ERROR);
            throw new SCAOperationExpiredException(EXPIRATION_ERROR);
        }
    }

    private void checkOperationNotUsed(SCAOperationEntity operation) throws SCAOperationUsedOrStolenException {
        if (this.isOperationAlreadyUsed(operation)) {
            logger.error(STOLEN_ERROR);
            throw new SCAOperationUsedOrStolenException(STOLEN_ERROR);
        }
    }

    private SCAOperationEntity createAuthCodeInternal(AuthCodeDataBO authCodeData, ScaStatusBO scaStatus) {
        if (authCodeData.getAuthorisationId() == null) {
            throw new ScaUncheckedException("Missing authorization id.");
        }
        SCAOperationEntity scaOp = new SCAOperationEntity();
        scaOp.setId(authCodeData.getAuthorisationId());
        scaOp.setOpId(authCodeData.getOpId());
        scaOp.setOpType(OpType.valueOf((String)authCodeData.getOpType().name()));
        scaOp.setScaMethodId(authCodeData.getScaUserDataId());
        scaOp.setStatus(AuthCodeStatus.INITIATED);
        scaOp.setStatusTime(LocalDateTime.now());
        int validitySeconds = authCodeData.getValiditySeconds() <= 0 ? this.authCodeValiditySeconds : authCodeData.getValiditySeconds();
        scaOp.setValiditySeconds(validitySeconds);
        scaOp.setScaStatus(ScaStatus.valueOf((String)scaStatus.name()));
        return (SCAOperationEntity)this.repository.save((Object)scaOp);
    }

    @NotNull
    private ScaUserDataBO getScaUserData(@NotNull List<ScaUserDataBO> scaUserData, @NotNull String scaUserDataId) throws UserScaDataNotFoundException {
        return scaUserData.stream().filter(s -> scaUserDataId.equals(s.getId())).findFirst().orElseThrow(() -> new UserScaDataNotFoundException(scaUserDataId));
    }

    @NotNull
    private SCAOperationEntity buildSCAOperation(SCAOperationEntity scaOperation, BaseHashItem<OperationHashItem> hashItem) {
        String authCodeHash = this.generateHashByOpData(hashItem);
        scaOperation.setCreated(LocalDateTime.now());
        int validitySeconds = scaOperation.getValiditySeconds() <= 0 ? this.authCodeValiditySeconds : scaOperation.getValiditySeconds();
        scaOperation.setValiditySeconds(validitySeconds);
        scaOperation.setStatus(AuthCodeStatus.SENT);
        scaOperation.setStatusTime(LocalDateTime.now());
        scaOperation.setHashAlg(hashItem.getAlg());
        scaOperation.setAuthCodeHash(authCodeHash);
        return scaOperation;
    }

    private String generateHashByOpData(BaseHashItem<OperationHashItem> hashItem) {
        String authCodeHash;
        try {
            authCodeHash = this.hashGenerator.hash(hashItem);
        }
        catch (HashGenerationException e) {
            logger.error(AUTH_CODE_GENERATION_ERROR, (Throwable)e);
            throw new ScaUncheckedException(AUTH_CODE_GENERATION_ERROR, (Throwable)e);
        }
        return authCodeHash;
    }

    private SCAOperationEntity loadOrCreateScaOperation(AuthCodeDataBO data, ScaStatusBO scaStatus) {
        if (data.getAuthorisationId() == null) {
            throw new ScaUncheckedException("Missing authorization id.");
        }
        return this.repository.findById((Object)data.getAuthorisationId()).orElse(this.createAuthCodeInternal(data, scaStatus));
    }

    private void checkMethodSupported(ScaUserDataBO scaMethod) throws SCAMethodNotSupportedException {
        if (!this.senders.containsKey(scaMethod.getScaMethod())) {
            throw new SCAMethodNotSupportedException();
        }
    }

    private boolean isOperationAlreadyUsed(SCAOperationEntity operation) {
        return operation.getStatus() == AuthCodeStatus.VALIDATED || operation.getStatus() == AuthCodeStatus.EXPIRED || operation.getStatus() == AuthCodeStatus.DONE || operation.getScaStatus() == ScaStatus.FAILED || operation.getScaStatus() == ScaStatus.FINALISED;
    }

    private boolean isOperationAlreadyExpired(SCAOperationEntity operation) {
        boolean hasExpiredStatus = operation.getStatus() == AuthCodeStatus.EXPIRED;
        int validitySeconds = operation.getValiditySeconds();
        return hasExpiredStatus || LocalDateTime.now().isAfter(operation.getCreated().plusSeconds(validitySeconds));
    }

    private void updateOperationStatus(SCAOperationEntity operation, AuthCodeStatus status, ScaStatus scaStatus) {
        operation.setStatus(status);
        operation.setScaStatus(scaStatus);
        operation.setStatusTime(LocalDateTime.now());
    }

    void setHashGenerator(HashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    void setSenders(Map<ScaMethodTypeBO, SCASender> senders) {
        this.senders = senders;
    }

    void setAuthCodeValiditySeconds(int authCodeValiditySeconds) {
        this.authCodeValiditySeconds = authCodeValiditySeconds;
    }

    void setAuthCodeEmailBody(String authCodeEmailBody) {
        this.authCodeEmailBody = authCodeEmailBody;
    }

    private static final class OperationHashItem {
        @JsonProperty
        private String id;
        @JsonProperty
        private String opId;
        @JsonProperty
        private String opData;
        @JsonProperty
        private String tan;

        public OperationHashItem(String id, String opId, String opData, String tan) {
            this.id = id;
            this.opId = opId;
            this.opData = opData;
            this.tan = tan;
        }
    }
}

