/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.db.domain;

import de.adorsys.ledgers.sca.db.domain.AuthCodeStatus;
import de.adorsys.ledgers.sca.db.domain.OpType;
import de.adorsys.ledgers.sca.db.domain.ScaStatus;
import java.time.LocalDateTime;
import java.util.EnumSet;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.hibernate.annotations.UpdateTimestamp;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@Entity
@Table(name="sca_operation")
public class SCAOperationEntity {
    @Id
    private String id;
    @Column(name="op_id", nullable=false, updatable=false)
    private String opId;
    @Column(name="external_id")
    private String externalId;
    @Column(name="validity_seconds", nullable=false, updatable=false)
    private int validitySeconds;
    @Column(name="auth_code_hash")
    private String authCodeHash;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AuthCodeStatus status;
    @Column(name="hash_alg")
    private String hashAlg;
    @Column(nullable=false, updatable=false)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime created;
    @Column(name="status_time", nullable=false)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime statusTime;
    @Column(name="op_type")
    @Enumerated(value=EnumType.STRING)
    private OpType opType;
    @Column(name="sca_method_id")
    private String scaMethodId;
    @Column(name="failled_count")
    private int failledCount;
    @Column(name="sca_status")
    @Enumerated(value=EnumType.STRING)
    private ScaStatus scaStatus;
    @Column(nullable=false)
    private int scaWeight;
    @Column
    @UpdateTimestamp
    private LocalDateTime updated;

    @PrePersist
    public void prePersist() {
        if (this.created == null) {
            this.created = LocalDateTime.now();
        }
    }

    public SCAOperationEntity updateStatuses(boolean isCodeConfirmValid) {
        this.status = AuthCodeStatus.VALIDATED;
        this.scaStatus = ScaStatus.FINALISED;
        if (!isCodeConfirmValid) {
            this.status = AuthCodeStatus.FAILED;
            this.scaStatus = ScaStatus.FAILED;
        }
        this.statusTime = LocalDateTime.now();
        return this;
    }

    public boolean isOperationExpired() {
        boolean hasExpiredStatus = this.status == AuthCodeStatus.EXPIRED;
        return hasExpiredStatus || LocalDateTime.now().isAfter(this.created.plusSeconds(this.validitySeconds));
    }

    public void validate(ScaStatus scaStatus, int scaWeight) {
        this.scaStatus = scaStatus;
        this.scaWeight = scaWeight;
        this.updateStatusAndTime(AuthCodeStatus.VALIDATED);
    }

    public void expireOperation() {
        this.scaStatus = ScaStatus.FAILED;
        this.scaWeight = 0;
        this.updateStatusAndTime(AuthCodeStatus.EXPIRED);
    }

    public boolean isOperationAlreadyUsed() {
        return EnumSet.of(AuthCodeStatus.VALIDATED, AuthCodeStatus.EXPIRED, AuthCodeStatus.DONE).contains((Object)this.status) || EnumSet.of(ScaStatus.FAILED, ScaStatus.FINALISED).contains((Object)this.scaStatus);
    }

    public SCAOperationEntity(String authId, String opId, String externalId, OpType opType, String scaMethodId, int validitySeconds, int authCodeValiditySeconds, ScaStatus scaStatus, int scaWeight) {
        this.id = authId;
        this.opId = opId;
        this.externalId = externalId;
        this.opType = opType;
        this.scaMethodId = scaMethodId;
        this.created = LocalDateTime.now();
        this.validitySeconds = validitySeconds <= 0 ? authCodeValiditySeconds : validitySeconds;
        this.scaStatus = scaStatus;
        this.scaWeight = scaWeight;
        this.updateStatusAndTime(AuthCodeStatus.INITIATED);
    }

    public void updateStatusSent(int authCodeValiditySeconds, String authCodeHash, String hashAlg) {
        this.created = LocalDateTime.now();
        this.validitySeconds = this.validitySeconds <= 0 ? authCodeValiditySeconds : this.validitySeconds;
        this.hashAlg = hashAlg;
        this.authCodeHash = authCodeHash;
        this.updateStatusAndTime(AuthCodeStatus.SENT);
    }

    public void fail(boolean isLoginOperation, int loginFailedMax, int authCodeFailedMax) {
        int failedMax;
        ++this.failledCount;
        int n = failedMax = isLoginOperation ? loginFailedMax : authCodeFailedMax;
        if (this.failledCount >= failedMax) {
            this.scaStatus = ScaStatus.FAILED;
        }
        this.updateStatusAndTime(AuthCodeStatus.FAILED);
    }

    private void updateStatusAndTime(AuthCodeStatus status) {
        this.statusTime = LocalDateTime.now();
        this.status = status;
    }

    private SCAOperationEntity() {
    }

    public String getId() {
        return this.id;
    }

    public String getOpId() {
        return this.opId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public int getValiditySeconds() {
        return this.validitySeconds;
    }

    public String getAuthCodeHash() {
        return this.authCodeHash;
    }

    public AuthCodeStatus getStatus() {
        return this.status;
    }

    public String getHashAlg() {
        return this.hashAlg;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public LocalDateTime getStatusTime() {
        return this.statusTime;
    }

    public OpType getOpType() {
        return this.opType;
    }

    public String getScaMethodId() {
        return this.scaMethodId;
    }

    public int getFailledCount() {
        return this.failledCount;
    }

    public ScaStatus getScaStatus() {
        return this.scaStatus;
    }

    public int getScaWeight() {
        return this.scaWeight;
    }

    public LocalDateTime getUpdated() {
        return this.updated;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOpId(String opId) {
        this.opId = opId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setValiditySeconds(int validitySeconds) {
        this.validitySeconds = validitySeconds;
    }

    public void setAuthCodeHash(String authCodeHash) {
        this.authCodeHash = authCodeHash;
    }

    public void setStatus(AuthCodeStatus status) {
        this.status = status;
    }

    public void setHashAlg(String hashAlg) {
        this.hashAlg = hashAlg;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public void setStatusTime(LocalDateTime statusTime) {
        this.statusTime = statusTime;
    }

    public void setOpType(OpType opType) {
        this.opType = opType;
    }

    public void setScaMethodId(String scaMethodId) {
        this.scaMethodId = scaMethodId;
    }

    public void setFailledCount(int failledCount) {
        this.failledCount = failledCount;
    }

    public void setScaStatus(ScaStatus scaStatus) {
        this.scaStatus = scaStatus;
    }

    public void setScaWeight(int scaWeight) {
        this.scaWeight = scaWeight;
    }

    public void setUpdated(LocalDateTime updated) {
        this.updated = updated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCAOperationEntity)) {
            return false;
        }
        SCAOperationEntity other = (SCAOperationEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$opId = this.getOpId();
        String other$opId = other.getOpId();
        if (this$opId == null ? other$opId != null : !this$opId.equals(other$opId)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        if (this.getValiditySeconds() != other.getValiditySeconds()) {
            return false;
        }
        String this$authCodeHash = this.getAuthCodeHash();
        String other$authCodeHash = other.getAuthCodeHash();
        if (this$authCodeHash == null ? other$authCodeHash != null : !this$authCodeHash.equals(other$authCodeHash)) {
            return false;
        }
        AuthCodeStatus this$status = this.getStatus();
        AuthCodeStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$hashAlg = this.getHashAlg();
        String other$hashAlg = other.getHashAlg();
        if (this$hashAlg == null ? other$hashAlg != null : !this$hashAlg.equals(other$hashAlg)) {
            return false;
        }
        LocalDateTime this$created = this.getCreated();
        LocalDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        LocalDateTime this$statusTime = this.getStatusTime();
        LocalDateTime other$statusTime = other.getStatusTime();
        if (this$statusTime == null ? other$statusTime != null : !((Object)this$statusTime).equals(other$statusTime)) {
            return false;
        }
        OpType this$opType = this.getOpType();
        OpType other$opType = other.getOpType();
        if (this$opType == null ? other$opType != null : !((Object)((Object)this$opType)).equals((Object)other$opType)) {
            return false;
        }
        String this$scaMethodId = this.getScaMethodId();
        String other$scaMethodId = other.getScaMethodId();
        if (this$scaMethodId == null ? other$scaMethodId != null : !this$scaMethodId.equals(other$scaMethodId)) {
            return false;
        }
        if (this.getFailledCount() != other.getFailledCount()) {
            return false;
        }
        ScaStatus this$scaStatus = this.getScaStatus();
        ScaStatus other$scaStatus = other.getScaStatus();
        if (this$scaStatus == null ? other$scaStatus != null : !((Object)((Object)this$scaStatus)).equals((Object)other$scaStatus)) {
            return false;
        }
        if (this.getScaWeight() != other.getScaWeight()) {
            return false;
        }
        LocalDateTime this$updated = this.getUpdated();
        LocalDateTime other$updated = other.getUpdated();
        return !(this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SCAOperationEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $opId = this.getOpId();
        result = result * 59 + ($opId == null ? 43 : $opId.hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        result = result * 59 + this.getValiditySeconds();
        String $authCodeHash = this.getAuthCodeHash();
        result = result * 59 + ($authCodeHash == null ? 43 : $authCodeHash.hashCode());
        AuthCodeStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $hashAlg = this.getHashAlg();
        result = result * 59 + ($hashAlg == null ? 43 : $hashAlg.hashCode());
        LocalDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        LocalDateTime $statusTime = this.getStatusTime();
        result = result * 59 + ($statusTime == null ? 43 : ((Object)$statusTime).hashCode());
        OpType $opType = this.getOpType();
        result = result * 59 + ($opType == null ? 43 : ((Object)((Object)$opType)).hashCode());
        String $scaMethodId = this.getScaMethodId();
        result = result * 59 + ($scaMethodId == null ? 43 : $scaMethodId.hashCode());
        result = result * 59 + this.getFailledCount();
        ScaStatus $scaStatus = this.getScaStatus();
        result = result * 59 + ($scaStatus == null ? 43 : ((Object)((Object)$scaStatus)).hashCode());
        result = result * 59 + this.getScaWeight();
        LocalDateTime $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        return result;
    }

    public String toString() {
        return "SCAOperationEntity(id=" + this.getId() + ", opId=" + this.getOpId() + ", externalId=" + this.getExternalId() + ", validitySeconds=" + this.getValiditySeconds() + ", authCodeHash=" + this.getAuthCodeHash() + ", status=" + this.getStatus() + ", hashAlg=" + this.getHashAlg() + ", created=" + this.getCreated() + ", statusTime=" + this.getStatusTime() + ", opType=" + this.getOpType() + ", scaMethodId=" + this.getScaMethodId() + ", failledCount=" + this.getFailledCount() + ", scaStatus=" + this.getScaStatus() + ", scaWeight=" + this.getScaWeight() + ", updated=" + this.getUpdated() + ")";
    }
}

