/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.db.domain;

import de.adorsys.ledgers.sca.db.domain.AuthCodeStatus;
import de.adorsys.ledgers.sca.db.domain.OpType;
import de.adorsys.ledgers.sca.db.domain.ScaStatus;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@Entity
@Table(name="sca_operation")
public class SCAOperationEntity {
    @Id
    private String id;
    @Column(name="op_id", nullable=false, updatable=false)
    private String opId;
    @Column(name="validity_seconds", nullable=false, updatable=false)
    private int validitySeconds;
    @Column(name="auth_code_hash")
    private String authCodeHash;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AuthCodeStatus status;
    @Column(name="hash_alg")
    private String hashAlg;
    @Column(nullable=false, updatable=false)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime created;
    @Column(name="status_time", nullable=false)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime statusTime;
    @Column(name="op_type")
    @Enumerated(value=EnumType.STRING)
    private OpType opType;
    @Column(name="sca_method_id")
    private String scaMethodId;
    @Column(name="failled_count")
    private int failledCount;
    @Column(name="sca_status")
    @Enumerated(value=EnumType.STRING)
    private ScaStatus scaStatus;

    @PrePersist
    public void prePersist() {
        if (this.created == null) {
            this.created = LocalDateTime.now();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOpId() {
        return this.opId;
    }

    public void setOpId(String opId) {
        this.opId = opId;
    }

    public int getValiditySeconds() {
        return this.validitySeconds;
    }

    public void setValiditySeconds(int validitySeconds) {
        this.validitySeconds = validitySeconds;
    }

    public String getAuthCodeHash() {
        return this.authCodeHash;
    }

    public void setAuthCodeHash(String authCodeHash) {
        this.authCodeHash = authCodeHash;
    }

    public AuthCodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(AuthCodeStatus status) {
        this.status = status;
    }

    public String getHashAlg() {
        return this.hashAlg;
    }

    public void setHashAlg(String hashAlg) {
        this.hashAlg = hashAlg;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public LocalDateTime getStatusTime() {
        return this.statusTime;
    }

    public void setStatusTime(LocalDateTime statusTime) {
        this.statusTime = statusTime;
    }

    public OpType getOpType() {
        return this.opType;
    }

    public void setOpType(OpType opType) {
        this.opType = opType;
    }

    public String getScaMethodId() {
        return this.scaMethodId;
    }

    public void setScaMethodId(String scaMethodId) {
        this.scaMethodId = scaMethodId;
    }

    public int getFailledCount() {
        return this.failledCount;
    }

    public void setFailledCount(int failledCount) {
        this.failledCount = failledCount;
    }

    public ScaStatus getScaStatus() {
        return this.scaStatus;
    }

    public void setScaStatus(ScaStatus scaStatus) {
        this.scaStatus = scaStatus;
    }
}

