/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.rest.exception;

import de.adorsys.ledgers.rest.exception.RestException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ExceptionAdvisor {
    private static final String MESSAGE = "message";
    private static final String DEV_MESSAGE = "devMessage";
    private static final String CODE = "code";
    private static final String DATE_TIME = "dateTime";

    @ExceptionHandler(value={RestException.class})
    public ResponseEntity<Map> handleRestException(RestException ex) {
        Map<String, String> body = this.getHandlerContent(ex.getCode(), ex.getMessage(), ex.devMessage);
        return new ResponseEntity(body, ex.getStatus());
    }

    private Map<String, String> getHandlerContent(HttpStatus status, String message, String devMessage) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put(CODE, String.valueOf(status.value()));
        error.put(MESSAGE, message);
        error.put(DEV_MESSAGE, devMessage);
        error.put(DATE_TIME, LocalDateTime.now().toString());
        return error;
    }

    private Map<String, String> getHandlerContent(String code, String message, String devMessage) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put(CODE, code);
        error.put(MESSAGE, message);
        error.put(DEV_MESSAGE, devMessage);
        error.put(DATE_TIME, LocalDateTime.now().toString());
        return error;
    }
}

