/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.rest.posting.controller;

import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerBO;
import de.adorsys.ledgers.postings.api.exception.ChartOfAccountNotFoundException;
import de.adorsys.ledgers.postings.api.exception.LedgerAccountNotFoundException;
import de.adorsys.ledgers.postings.api.exception.LedgerNotFoundException;
import de.adorsys.ledgers.postings.api.service.LedgerService;
import de.adorsys.ledgers.rest.exception.NotFoundRestException;
import java.net.URI;
import java.security.Principal;
import javax.websocket.server.PathParam;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriBuilder;

@RestController
public class LedgerController {
    private final Principal principal;
    private final LedgerService ledgerService;

    public LedgerController(Principal principal, LedgerService ledgerService) {
        this.principal = principal;
        this.ledgerService = ledgerService;
    }

    @PostMapping(path={"/ledgers"})
    public ResponseEntity<Void> newLedger(LedgerBO ledger, UriBuilder uri) {
        LedgerBO newLedger;
        try {
            newLedger = this.ledgerService.newLedger(ledger);
        }
        catch (ChartOfAccountNotFoundException | LedgerNotFoundException e) {
            throw new NotFoundRestException(e.getMessage());
        }
        URI location = uri.path(newLedger.getId()).build(new Object[0]);
        return ResponseEntity.created((URI)location).build();
    }

    @GetMapping(path={"/ledgers/{id}"})
    public ResponseEntity<LedgerBO> findLedgerById(@PathVariable(value="id") String id) {
        LedgerBO ledger = (LedgerBO)this.ledgerService.findLedgerById(id).orElseThrow(() -> new NotFoundRestException(id));
        return ResponseEntity.ok((Object)ledger);
    }

    @GetMapping(path={"/ledgers"}, params={"ledgerName"})
    public ResponseEntity<LedgerBO> findLedgerByName(@RequestParam(required=true, name="ledgerName") String ledgerName) {
        LedgerBO ledger = (LedgerBO)this.ledgerService.findLedgerByName(ledgerName).orElseThrow(() -> new NotFoundRestException(ledgerName));
        return ResponseEntity.ok((Object)ledger);
    }

    @PostMapping(path={"/accounts"})
    public ResponseEntity<Void> newLedgerAccount(@RequestBody LedgerAccountBO ledgerAccount, UriBuilder uri) {
        LedgerAccountBO newLedgerAccount;
        try {
            newLedgerAccount = this.ledgerService.newLedgerAccount(ledgerAccount, this.principal.getName());
        }
        catch (LedgerAccountNotFoundException | LedgerNotFoundException e) {
            throw new NotFoundRestException(e.getMessage());
        }
        URI location = uri.path(newLedgerAccount.getId()).build(new Object[0]);
        return ResponseEntity.created((URI)location).build();
    }

    @GetMapping(path={"/accounts/{id}"})
    public ResponseEntity<LedgerAccountBO> findLedgerAccountById(@PathVariable(value="id") String id) {
        LedgerAccountBO la = (LedgerAccountBO)this.ledgerService.findLedgerAccountById(id).orElseThrow(() -> new NotFoundRestException(id));
        return ResponseEntity.ok((Object)la);
    }

    @GetMapping(path={"/accounts"}, params={"ledgerName", "accountName"})
    public ResponseEntity<LedgerAccountBO> findLedgerAccountByName(@RequestParam(required=true, name="ledgerName") String ledgerName, @RequestParam(required=true, name="accountName") String accountName) throws LedgerNotFoundException, LedgerAccountNotFoundException {
        LedgerBO ledger = new LedgerBO();
        ledger.setName(ledgerName);
        return this.ledgerAccount(ledger, accountName);
    }

    @GetMapping(path={"/ledgers/{ledgerId}/accounts"}, params={"accountName"})
    public ResponseEntity<LedgerAccountBO> findLedgerAccount(@PathParam(value="ledgerId") String ledgerId, @RequestParam(required=true, name="accountName") String accountName) throws LedgerNotFoundException, LedgerAccountNotFoundException {
        LedgerBO ledger = new LedgerBO();
        ledger.setId(ledgerId);
        return this.ledgerAccount(ledger, accountName);
    }

    private ResponseEntity<LedgerAccountBO> ledgerAccount(LedgerBO ledger, String accountName) throws LedgerNotFoundException, LedgerAccountNotFoundException {
        LedgerAccountBO ledgerAccount = this.ledgerService.findLedgerAccount(ledger, accountName);
        return ResponseEntity.ok((Object)ledgerAccount);
    }
}

