/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.rest.posting.controller;

import de.adorsys.ledgers.postings.api.domain.ChartOfAccountBO;
import de.adorsys.ledgers.postings.api.service.ChartOfAccountService;
import de.adorsys.ledgers.rest.exception.NotFoundRestException;
import java.net.URI;
import java.security.Principal;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriBuilder;

@RestController
public class ChartOfAccountController {
    private final Principal principal;
    private final ChartOfAccountService chartOfAccountService;

    public ChartOfAccountController(Principal principal, ChartOfAccountService chartOfAccountService) {
        this.principal = principal;
        this.chartOfAccountService = chartOfAccountService;
    }

    @PostMapping(path={"/coas"})
    public ResponseEntity<Void> newChartOfAccount(ChartOfAccountBO chartOfAccount, UriBuilder uri) {
        chartOfAccount.setUserDetails(this.principal.getName());
        ChartOfAccountBO coa = this.chartOfAccountService.newChartOfAccount(chartOfAccount);
        URI location = uri.path(coa.getId()).build(new Object[0]);
        return ResponseEntity.created((URI)location).build();
    }

    @GetMapping(path={"/coas/{id}"})
    public ResponseEntity<ChartOfAccountBO> findChartOfAccountsById(@PathVariable(value="id") String id) {
        ChartOfAccountBO coa = (ChartOfAccountBO)this.chartOfAccountService.findChartOfAccountsById(id).orElseThrow(() -> new NotFoundRestException(id));
        return ResponseEntity.ok((Object)coa);
    }

    @GetMapping(path={"/coas"}, params={"name"})
    public ResponseEntity<ChartOfAccountBO> findChartOfAccountsByName(@RequestParam(required=true, name="name") String name) {
        ChartOfAccountBO coa = (ChartOfAccountBO)this.chartOfAccountService.findChartOfAccountsByName(name).orElseThrow(() -> new NotFoundRestException(name));
        return ResponseEntity.ok((Object)coa);
    }
}

