/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.ledgers.postings.db.domain.LedgerAccount;
import de.adorsys.ledgers.postings.db.domain.OperationDetails;
import de.adorsys.ledgers.postings.db.domain.Posting;
import de.adorsys.ledgers.postings.db.domain.PostingStatus;
import de.adorsys.ledgers.postings.db.domain.PostingType;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@Entity
public class PostingLine {
    @Id
    private String id;
    @ManyToOne(optional=false)
    private LedgerAccount account;
    @Column(nullable=false, updatable=false)
    private BigDecimal debitAmount;
    @Column(nullable=false, updatable=false)
    private BigDecimal creditAmount;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnore
    private OperationDetails details;
    private String srcAccount;
    private String baseLine;
    private String subOprSrcId;
    @Column(nullable=false, updatable=false)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime recordTime;
    @Column(nullable=false, updatable=false)
    private String oprId;
    private String oprSrc;
    @Column(nullable=false, updatable=false)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime pstTime;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, updatable=false)
    private PostingType pstType;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, updatable=false)
    private PostingStatus pstStatus;
    @Column(nullable=false)
    private String hash;
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime discardedTime;

    public void synchPosting(Posting posting) {
        this.recordTime = posting.getRecordTime();
        this.oprId = posting.getOprId();
        this.pstTime = posting.getPstTime();
        this.pstType = posting.getPstType();
        this.pstStatus = posting.getPstStatus();
        this.hash = posting.getHash();
        this.discardedTime = posting.getDiscardedTime();
        this.oprSrc = posting.getOprSrc();
    }

    public String getId() {
        return this.id;
    }

    public LedgerAccount getAccount() {
        return this.account;
    }

    public BigDecimal getDebitAmount() {
        return this.debitAmount;
    }

    public BigDecimal getCreditAmount() {
        return this.creditAmount;
    }

    public OperationDetails getDetails() {
        return this.details;
    }

    public String getSrcAccount() {
        return this.srcAccount;
    }

    public String getBaseLine() {
        return this.baseLine;
    }

    public String getSubOprSrcId() {
        return this.subOprSrcId;
    }

    public LocalDateTime getRecordTime() {
        return this.recordTime;
    }

    public String getOprId() {
        return this.oprId;
    }

    public String getOprSrc() {
        return this.oprSrc;
    }

    public LocalDateTime getPstTime() {
        return this.pstTime;
    }

    public PostingType getPstType() {
        return this.pstType;
    }

    public PostingStatus getPstStatus() {
        return this.pstStatus;
    }

    public String getHash() {
        return this.hash;
    }

    public LocalDateTime getDiscardedTime() {
        return this.discardedTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAccount(LedgerAccount account) {
        this.account = account;
    }

    public void setDebitAmount(BigDecimal debitAmount) {
        this.debitAmount = debitAmount;
    }

    public void setCreditAmount(BigDecimal creditAmount) {
        this.creditAmount = creditAmount;
    }

    public void setDetails(OperationDetails details) {
        this.details = details;
    }

    public void setSrcAccount(String srcAccount) {
        this.srcAccount = srcAccount;
    }

    public void setBaseLine(String baseLine) {
        this.baseLine = baseLine;
    }

    public void setSubOprSrcId(String subOprSrcId) {
        this.subOprSrcId = subOprSrcId;
    }

    public void setRecordTime(LocalDateTime recordTime) {
        this.recordTime = recordTime;
    }

    public void setOprId(String oprId) {
        this.oprId = oprId;
    }

    public void setOprSrc(String oprSrc) {
        this.oprSrc = oprSrc;
    }

    public void setPstTime(LocalDateTime pstTime) {
        this.pstTime = pstTime;
    }

    public void setPstType(PostingType pstType) {
        this.pstType = pstType;
    }

    public void setPstStatus(PostingStatus pstStatus) {
        this.pstStatus = pstStatus;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setDiscardedTime(LocalDateTime discardedTime) {
        this.discardedTime = discardedTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostingLine)) {
            return false;
        }
        PostingLine other = (PostingLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LedgerAccount this$account = this.getAccount();
        LedgerAccount other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        BigDecimal this$debitAmount = this.getDebitAmount();
        BigDecimal other$debitAmount = other.getDebitAmount();
        if (this$debitAmount == null ? other$debitAmount != null : !((Object)this$debitAmount).equals(other$debitAmount)) {
            return false;
        }
        BigDecimal this$creditAmount = this.getCreditAmount();
        BigDecimal other$creditAmount = other.getCreditAmount();
        if (this$creditAmount == null ? other$creditAmount != null : !((Object)this$creditAmount).equals(other$creditAmount)) {
            return false;
        }
        OperationDetails this$details = this.getDetails();
        OperationDetails other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        String this$srcAccount = this.getSrcAccount();
        String other$srcAccount = other.getSrcAccount();
        if (this$srcAccount == null ? other$srcAccount != null : !this$srcAccount.equals(other$srcAccount)) {
            return false;
        }
        String this$baseLine = this.getBaseLine();
        String other$baseLine = other.getBaseLine();
        if (this$baseLine == null ? other$baseLine != null : !this$baseLine.equals(other$baseLine)) {
            return false;
        }
        String this$subOprSrcId = this.getSubOprSrcId();
        String other$subOprSrcId = other.getSubOprSrcId();
        if (this$subOprSrcId == null ? other$subOprSrcId != null : !this$subOprSrcId.equals(other$subOprSrcId)) {
            return false;
        }
        LocalDateTime this$recordTime = this.getRecordTime();
        LocalDateTime other$recordTime = other.getRecordTime();
        if (this$recordTime == null ? other$recordTime != null : !((Object)this$recordTime).equals(other$recordTime)) {
            return false;
        }
        String this$oprId = this.getOprId();
        String other$oprId = other.getOprId();
        if (this$oprId == null ? other$oprId != null : !this$oprId.equals(other$oprId)) {
            return false;
        }
        String this$oprSrc = this.getOprSrc();
        String other$oprSrc = other.getOprSrc();
        if (this$oprSrc == null ? other$oprSrc != null : !this$oprSrc.equals(other$oprSrc)) {
            return false;
        }
        LocalDateTime this$pstTime = this.getPstTime();
        LocalDateTime other$pstTime = other.getPstTime();
        if (this$pstTime == null ? other$pstTime != null : !((Object)this$pstTime).equals(other$pstTime)) {
            return false;
        }
        PostingType this$pstType = this.getPstType();
        PostingType other$pstType = other.getPstType();
        if (this$pstType == null ? other$pstType != null : !((Object)((Object)this$pstType)).equals((Object)other$pstType)) {
            return false;
        }
        PostingStatus this$pstStatus = this.getPstStatus();
        PostingStatus other$pstStatus = other.getPstStatus();
        if (this$pstStatus == null ? other$pstStatus != null : !((Object)((Object)this$pstStatus)).equals((Object)other$pstStatus)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        LocalDateTime this$discardedTime = this.getDiscardedTime();
        LocalDateTime other$discardedTime = other.getDiscardedTime();
        return !(this$discardedTime == null ? other$discardedTime != null : !((Object)this$discardedTime).equals(other$discardedTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostingLine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LedgerAccount $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        BigDecimal $debitAmount = this.getDebitAmount();
        result = result * 59 + ($debitAmount == null ? 43 : ((Object)$debitAmount).hashCode());
        BigDecimal $creditAmount = this.getCreditAmount();
        result = result * 59 + ($creditAmount == null ? 43 : ((Object)$creditAmount).hashCode());
        OperationDetails $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        String $srcAccount = this.getSrcAccount();
        result = result * 59 + ($srcAccount == null ? 43 : $srcAccount.hashCode());
        String $baseLine = this.getBaseLine();
        result = result * 59 + ($baseLine == null ? 43 : $baseLine.hashCode());
        String $subOprSrcId = this.getSubOprSrcId();
        result = result * 59 + ($subOprSrcId == null ? 43 : $subOprSrcId.hashCode());
        LocalDateTime $recordTime = this.getRecordTime();
        result = result * 59 + ($recordTime == null ? 43 : ((Object)$recordTime).hashCode());
        String $oprId = this.getOprId();
        result = result * 59 + ($oprId == null ? 43 : $oprId.hashCode());
        String $oprSrc = this.getOprSrc();
        result = result * 59 + ($oprSrc == null ? 43 : $oprSrc.hashCode());
        LocalDateTime $pstTime = this.getPstTime();
        result = result * 59 + ($pstTime == null ? 43 : ((Object)$pstTime).hashCode());
        PostingType $pstType = this.getPstType();
        result = result * 59 + ($pstType == null ? 43 : ((Object)((Object)$pstType)).hashCode());
        PostingStatus $pstStatus = this.getPstStatus();
        result = result * 59 + ($pstStatus == null ? 43 : ((Object)((Object)$pstStatus)).hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        LocalDateTime $discardedTime = this.getDiscardedTime();
        result = result * 59 + ($discardedTime == null ? 43 : ((Object)$discardedTime).hashCode());
        return result;
    }
}

