/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import de.adorsys.ledgers.postings.db.domain.HashRecord;
import de.adorsys.ledgers.postings.db.domain.Ledger;
import de.adorsys.ledgers.postings.db.domain.OperationDetails;
import de.adorsys.ledgers.postings.db.domain.PostingLine;
import de.adorsys.ledgers.postings.db.domain.PostingStatus;
import de.adorsys.ledgers.postings.db.domain.PostingType;
import de.adorsys.ledgers.postings.db.utils.RecordHashHelper;
import de.adorsys.ledgers.util.hash.HashGenerationException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@Entity
@JsonPropertyOrder(alphabetic=true)
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"opr_id", "discarding_id"}, name="Posting_opr_id_discarding_id_unique")})
public class Posting
extends HashRecord {
    private static final RecordHashHelper RECORD_HASH_HELPER = new RecordHashHelper();
    @Id
    private String id;
    @Column(nullable=false, updatable=false)
    private String recordUser;
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime recordTime;
    @Column(nullable=false, updatable=false, name="opr_id")
    private String oprId;
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime oprTime;
    private String oprType;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnore
    private OperationDetails oprDetails;
    private String oprSrc;
    @Column(nullable=false, updatable=false)
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime pstTime;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, updatable=false)
    private PostingType pstType;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, updatable=false)
    private PostingStatus pstStatus = PostingStatus.POSTED;
    @ManyToOne(optional=false)
    private Ledger ledger;
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime valTime;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="posting_id")
    private List<PostingLine> lines = new ArrayList<PostingLine>();
    private String discardedId;
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime discardedTime;
    @Column(name="discarding_id")
    private String discardingId;

    public Posting hash() {
        if (this.hash != null) {
            return this;
        }
        if (this.recordTime == null) {
            this.recordTime = LocalDateTime.now();
        }
        try {
            this.hash = RECORD_HASH_HELPER.computeRecHash(this);
        }
        catch (HashGenerationException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public void synchLines() {
        this.lines.forEach(l -> l.synchPosting(this));
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRecordUser(String recordUser) {
        this.recordUser = recordUser;
    }

    public void setRecordTime(LocalDateTime recordTime) {
        this.recordTime = recordTime;
    }

    public void setOprId(String oprId) {
        this.oprId = oprId;
    }

    public void setOprTime(LocalDateTime oprTime) {
        this.oprTime = oprTime;
    }

    public void setOprType(String oprType) {
        this.oprType = oprType;
    }

    public void setOprDetails(OperationDetails oprDetails) {
        this.oprDetails = oprDetails;
    }

    public void setOprSrc(String oprSrc) {
        this.oprSrc = oprSrc;
    }

    public void setPstTime(LocalDateTime pstTime) {
        this.pstTime = pstTime;
    }

    public void setPstType(PostingType pstType) {
        this.pstType = pstType;
    }

    public void setPstStatus(PostingStatus pstStatus) {
        this.pstStatus = pstStatus;
    }

    public void setLedger(Ledger ledger) {
        this.ledger = ledger;
    }

    public void setValTime(LocalDateTime valTime) {
        this.valTime = valTime;
    }

    public void setLines(List<PostingLine> lines) {
        this.lines = lines;
    }

    public void setDiscardedId(String discardedId) {
        this.discardedId = discardedId;
    }

    public void setDiscardedTime(LocalDateTime discardedTime) {
        this.discardedTime = discardedTime;
    }

    public void setDiscardingId(String discardingId) {
        this.discardingId = discardingId;
    }

    public String getId() {
        return this.id;
    }

    public String getRecordUser() {
        return this.recordUser;
    }

    public LocalDateTime getRecordTime() {
        return this.recordTime;
    }

    public String getOprId() {
        return this.oprId;
    }

    public LocalDateTime getOprTime() {
        return this.oprTime;
    }

    public String getOprType() {
        return this.oprType;
    }

    public OperationDetails getOprDetails() {
        return this.oprDetails;
    }

    public String getOprSrc() {
        return this.oprSrc;
    }

    public LocalDateTime getPstTime() {
        return this.pstTime;
    }

    public PostingType getPstType() {
        return this.pstType;
    }

    public PostingStatus getPstStatus() {
        return this.pstStatus;
    }

    public Ledger getLedger() {
        return this.ledger;
    }

    public LocalDateTime getValTime() {
        return this.valTime;
    }

    public List<PostingLine> getLines() {
        return this.lines;
    }

    public String getDiscardedId() {
        return this.discardedId;
    }

    public LocalDateTime getDiscardedTime() {
        return this.discardedTime;
    }

    public String getDiscardingId() {
        return this.discardingId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Posting)) {
            return false;
        }
        Posting other = (Posting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$recordUser = this.getRecordUser();
        String other$recordUser = other.getRecordUser();
        if (this$recordUser == null ? other$recordUser != null : !this$recordUser.equals(other$recordUser)) {
            return false;
        }
        LocalDateTime this$recordTime = this.getRecordTime();
        LocalDateTime other$recordTime = other.getRecordTime();
        if (this$recordTime == null ? other$recordTime != null : !((Object)this$recordTime).equals(other$recordTime)) {
            return false;
        }
        String this$oprId = this.getOprId();
        String other$oprId = other.getOprId();
        if (this$oprId == null ? other$oprId != null : !this$oprId.equals(other$oprId)) {
            return false;
        }
        LocalDateTime this$oprTime = this.getOprTime();
        LocalDateTime other$oprTime = other.getOprTime();
        if (this$oprTime == null ? other$oprTime != null : !((Object)this$oprTime).equals(other$oprTime)) {
            return false;
        }
        String this$oprType = this.getOprType();
        String other$oprType = other.getOprType();
        if (this$oprType == null ? other$oprType != null : !this$oprType.equals(other$oprType)) {
            return false;
        }
        OperationDetails this$oprDetails = this.getOprDetails();
        OperationDetails other$oprDetails = other.getOprDetails();
        if (this$oprDetails == null ? other$oprDetails != null : !((Object)this$oprDetails).equals(other$oprDetails)) {
            return false;
        }
        String this$oprSrc = this.getOprSrc();
        String other$oprSrc = other.getOprSrc();
        if (this$oprSrc == null ? other$oprSrc != null : !this$oprSrc.equals(other$oprSrc)) {
            return false;
        }
        LocalDateTime this$pstTime = this.getPstTime();
        LocalDateTime other$pstTime = other.getPstTime();
        if (this$pstTime == null ? other$pstTime != null : !((Object)this$pstTime).equals(other$pstTime)) {
            return false;
        }
        PostingType this$pstType = this.getPstType();
        PostingType other$pstType = other.getPstType();
        if (this$pstType == null ? other$pstType != null : !((Object)((Object)this$pstType)).equals((Object)other$pstType)) {
            return false;
        }
        PostingStatus this$pstStatus = this.getPstStatus();
        PostingStatus other$pstStatus = other.getPstStatus();
        if (this$pstStatus == null ? other$pstStatus != null : !((Object)((Object)this$pstStatus)).equals((Object)other$pstStatus)) {
            return false;
        }
        Ledger this$ledger = this.getLedger();
        Ledger other$ledger = other.getLedger();
        if (this$ledger == null ? other$ledger != null : !((Object)this$ledger).equals(other$ledger)) {
            return false;
        }
        LocalDateTime this$valTime = this.getValTime();
        LocalDateTime other$valTime = other.getValTime();
        if (this$valTime == null ? other$valTime != null : !((Object)this$valTime).equals(other$valTime)) {
            return false;
        }
        List<PostingLine> this$lines = this.getLines();
        List<PostingLine> other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        String this$discardedId = this.getDiscardedId();
        String other$discardedId = other.getDiscardedId();
        if (this$discardedId == null ? other$discardedId != null : !this$discardedId.equals(other$discardedId)) {
            return false;
        }
        LocalDateTime this$discardedTime = this.getDiscardedTime();
        LocalDateTime other$discardedTime = other.getDiscardedTime();
        if (this$discardedTime == null ? other$discardedTime != null : !((Object)this$discardedTime).equals(other$discardedTime)) {
            return false;
        }
        String this$discardingId = this.getDiscardingId();
        String other$discardingId = other.getDiscardingId();
        return !(this$discardingId == null ? other$discardingId != null : !this$discardingId.equals(other$discardingId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Posting;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $recordUser = this.getRecordUser();
        result = result * 59 + ($recordUser == null ? 43 : $recordUser.hashCode());
        LocalDateTime $recordTime = this.getRecordTime();
        result = result * 59 + ($recordTime == null ? 43 : ((Object)$recordTime).hashCode());
        String $oprId = this.getOprId();
        result = result * 59 + ($oprId == null ? 43 : $oprId.hashCode());
        LocalDateTime $oprTime = this.getOprTime();
        result = result * 59 + ($oprTime == null ? 43 : ((Object)$oprTime).hashCode());
        String $oprType = this.getOprType();
        result = result * 59 + ($oprType == null ? 43 : $oprType.hashCode());
        OperationDetails $oprDetails = this.getOprDetails();
        result = result * 59 + ($oprDetails == null ? 43 : ((Object)$oprDetails).hashCode());
        String $oprSrc = this.getOprSrc();
        result = result * 59 + ($oprSrc == null ? 43 : $oprSrc.hashCode());
        LocalDateTime $pstTime = this.getPstTime();
        result = result * 59 + ($pstTime == null ? 43 : ((Object)$pstTime).hashCode());
        PostingType $pstType = this.getPstType();
        result = result * 59 + ($pstType == null ? 43 : ((Object)((Object)$pstType)).hashCode());
        PostingStatus $pstStatus = this.getPstStatus();
        result = result * 59 + ($pstStatus == null ? 43 : ((Object)((Object)$pstStatus)).hashCode());
        Ledger $ledger = this.getLedger();
        result = result * 59 + ($ledger == null ? 43 : ((Object)$ledger).hashCode());
        LocalDateTime $valTime = this.getValTime();
        result = result * 59 + ($valTime == null ? 43 : ((Object)$valTime).hashCode());
        List<PostingLine> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        String $discardedId = this.getDiscardedId();
        result = result * 59 + ($discardedId == null ? 43 : $discardedId.hashCode());
        LocalDateTime $discardedTime = this.getDiscardedTime();
        result = result * 59 + ($discardedTime == null ? 43 : ((Object)$discardedTime).hashCode());
        String $discardingId = this.getDiscardingId();
        result = result * 59 + ($discardingId == null ? 43 : $discardingId.hashCode());
        return result;
    }
}

