/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import de.adorsys.ledgers.postings.db.domain.AccountCategory;
import de.adorsys.ledgers.postings.db.domain.BalanceSide;
import de.adorsys.ledgers.postings.db.domain.ChartOfAccount;
import de.adorsys.ledgers.postings.db.domain.Ledger;
import de.adorsys.ledgers.postings.db.domain.NamedEntity;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"ledger_id", "name"}, name="LedgerAccount_ledger_id_name_unique")})
public class LedgerAccount
extends NamedEntity {
    @ManyToOne(optional=false)
    private Ledger ledger;
    @ManyToOne(optional=true)
    private LedgerAccount parent;
    @ManyToOne(optional=false)
    private ChartOfAccount coa;
    @Column(nullable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    private BalanceSide balanceSide;
    @Column(nullable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    private AccountCategory category;

    public LedgerAccount(String id, LocalDateTime created, String user, String shortDesc, String longDesc, String name, Ledger ledger, LedgerAccount parent, ChartOfAccount coa, BalanceSide balanceSide, AccountCategory category) {
        super(id, created, user, shortDesc, longDesc, name);
        this.ledger = ledger;
        this.parent = parent;
        this.coa = coa;
        this.balanceSide = balanceSide;
        this.category = category;
    }

    public LedgerAccount() {
    }

    public Ledger getLedger() {
        return this.ledger;
    }

    public LedgerAccount getParent() {
        return this.parent;
    }

    public ChartOfAccount getCoa() {
        return this.coa;
    }

    public BalanceSide getBalanceSide() {
        return this.balanceSide;
    }

    public AccountCategory getCategory() {
        return this.category;
    }

    public void setLedger(Ledger ledger) {
        this.ledger = ledger;
    }

    public void setParent(LedgerAccount parent) {
        this.parent = parent;
    }

    public void setCoa(ChartOfAccount coa) {
        this.coa = coa;
    }

    public void setBalanceSide(BalanceSide balanceSide) {
        this.balanceSide = balanceSide;
    }

    public void setCategory(AccountCategory category) {
        this.category = category;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerAccount)) {
            return false;
        }
        LedgerAccount other = (LedgerAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Ledger this$ledger = this.getLedger();
        Ledger other$ledger = other.getLedger();
        if (this$ledger == null ? other$ledger != null : !((Object)this$ledger).equals(other$ledger)) {
            return false;
        }
        LedgerAccount this$parent = this.getParent();
        LedgerAccount other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        ChartOfAccount this$coa = this.getCoa();
        ChartOfAccount other$coa = other.getCoa();
        if (this$coa == null ? other$coa != null : !((Object)this$coa).equals(other$coa)) {
            return false;
        }
        BalanceSide this$balanceSide = this.getBalanceSide();
        BalanceSide other$balanceSide = other.getBalanceSide();
        if (this$balanceSide == null ? other$balanceSide != null : !((Object)((Object)this$balanceSide)).equals((Object)other$balanceSide)) {
            return false;
        }
        AccountCategory this$category = this.getCategory();
        AccountCategory other$category = other.getCategory();
        return !(this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LedgerAccount;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Ledger $ledger = this.getLedger();
        result = result * 59 + ($ledger == null ? 43 : ((Object)$ledger).hashCode());
        LedgerAccount $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        ChartOfAccount $coa = this.getCoa();
        result = result * 59 + ($coa == null ? 43 : ((Object)$coa).hashCode());
        BalanceSide $balanceSide = this.getBalanceSide();
        result = result * 59 + ($balanceSide == null ? 43 : ((Object)((Object)$balanceSide)).hashCode());
        AccountCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        return result;
    }
}

