/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import de.adorsys.ledgers.postings.db.domain.Posting;
import de.adorsys.ledgers.postings.db.domain.PostingTrace;
import de.adorsys.ledgers.postings.db.domain.StmtStatus;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@MappedSuperclass
public abstract class FinancialStmt {
    @Id
    private String id;
    @OneToOne
    private Posting posting;
    @Column(nullable=false, updatable=false)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime pstTime;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, updatable=false)
    private StmtStatus stmtStatus;
    @OneToOne
    private PostingTrace latestPst;
    @Column(nullable=false, updatable=false)
    private int stmtSeqNbr = 0;

    public String getId() {
        return this.id;
    }

    public Posting getPosting() {
        return this.posting;
    }

    public LocalDateTime getPstTime() {
        return this.pstTime;
    }

    public StmtStatus getStmtStatus() {
        return this.stmtStatus;
    }

    public PostingTrace getLatestPst() {
        return this.latestPst;
    }

    public int getStmtSeqNbr() {
        return this.stmtSeqNbr;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPosting(Posting posting) {
        this.posting = posting;
    }

    public void setPstTime(LocalDateTime pstTime) {
        this.pstTime = pstTime;
    }

    public void setStmtStatus(StmtStatus stmtStatus) {
        this.stmtStatus = stmtStatus;
    }

    public void setLatestPst(PostingTrace latestPst) {
        this.latestPst = latestPst;
    }

    public void setStmtSeqNbr(int stmtSeqNbr) {
        this.stmtSeqNbr = stmtSeqNbr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FinancialStmt)) {
            return false;
        }
        FinancialStmt other = (FinancialStmt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Posting this$posting = this.getPosting();
        Posting other$posting = other.getPosting();
        if (this$posting == null ? other$posting != null : !((Object)this$posting).equals(other$posting)) {
            return false;
        }
        LocalDateTime this$pstTime = this.getPstTime();
        LocalDateTime other$pstTime = other.getPstTime();
        if (this$pstTime == null ? other$pstTime != null : !((Object)this$pstTime).equals(other$pstTime)) {
            return false;
        }
        StmtStatus this$stmtStatus = this.getStmtStatus();
        StmtStatus other$stmtStatus = other.getStmtStatus();
        if (this$stmtStatus == null ? other$stmtStatus != null : !((Object)((Object)this$stmtStatus)).equals((Object)other$stmtStatus)) {
            return false;
        }
        PostingTrace this$latestPst = this.getLatestPst();
        PostingTrace other$latestPst = other.getLatestPst();
        if (this$latestPst == null ? other$latestPst != null : !((Object)this$latestPst).equals(other$latestPst)) {
            return false;
        }
        return this.getStmtSeqNbr() == other.getStmtSeqNbr();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FinancialStmt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Posting $posting = this.getPosting();
        result = result * 59 + ($posting == null ? 43 : ((Object)$posting).hashCode());
        LocalDateTime $pstTime = this.getPstTime();
        result = result * 59 + ($pstTime == null ? 43 : ((Object)$pstTime).hashCode());
        StmtStatus $stmtStatus = this.getStmtStatus();
        result = result * 59 + ($stmtStatus == null ? 43 : ((Object)((Object)$stmtStatus)).hashCode());
        PostingTrace $latestPst = this.getLatestPst();
        result = result * 59 + ($latestPst == null ? 43 : ((Object)$latestPst).hashCode());
        result = result * 59 + this.getStmtSeqNbr();
        return result;
    }
}

