/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import de.adorsys.ledgers.postings.db.domain.FinancialStmt;
import de.adorsys.ledgers.postings.db.domain.LedgerAccount;
import de.adorsys.ledgers.postings.db.domain.PostingTrace;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;

@Entity
public class AccountStmt
extends FinancialStmt {
    @ManyToOne(optional=false)
    private LedgerAccount account;
    @OneToOne
    private PostingTrace youngestPst;
    @Column(nullable=false)
    private BigDecimal totalDebit;
    @Column(nullable=false)
    private BigDecimal totalCredit;

    @PrePersist
    public void prePersist() {
        this.setId(AccountStmt.makeId(this.account, this.getPstTime(), this.getStmtSeqNbr()));
    }

    public final Optional<String> clonedId() {
        return Optional.ofNullable(this.getStmtSeqNbr() <= 0 ? null : AccountStmt.makeId(this.account, this.getPstTime(), this.getStmtSeqNbr() - 1));
    }

    public static String makeId(LedgerAccount account, LocalDateTime pstTime, int stmtSeqNbr) {
        return AccountStmt.makeOperationId(account, pstTime) + "_" + stmtSeqNbr;
    }

    public static String makeOperationId(LedgerAccount account, LocalDateTime pstTime) {
        return account.getId() + "_" + pstTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public LedgerAccount getAccount() {
        return this.account;
    }

    public PostingTrace getYoungestPst() {
        return this.youngestPst;
    }

    public BigDecimal getTotalDebit() {
        return this.totalDebit;
    }

    public BigDecimal getTotalCredit() {
        return this.totalCredit;
    }

    public void setAccount(LedgerAccount account) {
        this.account = account;
    }

    public void setYoungestPst(PostingTrace youngestPst) {
        this.youngestPst = youngestPst;
    }

    public void setTotalDebit(BigDecimal totalDebit) {
        this.totalDebit = totalDebit;
    }

    public void setTotalCredit(BigDecimal totalCredit) {
        this.totalCredit = totalCredit;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountStmt)) {
            return false;
        }
        AccountStmt other = (AccountStmt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LedgerAccount this$account = this.getAccount();
        LedgerAccount other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        PostingTrace this$youngestPst = this.getYoungestPst();
        PostingTrace other$youngestPst = other.getYoungestPst();
        if (this$youngestPst == null ? other$youngestPst != null : !((Object)this$youngestPst).equals(other$youngestPst)) {
            return false;
        }
        BigDecimal this$totalDebit = this.getTotalDebit();
        BigDecimal other$totalDebit = other.getTotalDebit();
        if (this$totalDebit == null ? other$totalDebit != null : !((Object)this$totalDebit).equals(other$totalDebit)) {
            return false;
        }
        BigDecimal this$totalCredit = this.getTotalCredit();
        BigDecimal other$totalCredit = other.getTotalCredit();
        return !(this$totalCredit == null ? other$totalCredit != null : !((Object)this$totalCredit).equals(other$totalCredit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AccountStmt;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LedgerAccount $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        PostingTrace $youngestPst = this.getYoungestPst();
        result = result * 59 + ($youngestPst == null ? 43 : ((Object)$youngestPst).hashCode());
        BigDecimal $totalDebit = this.getTotalDebit();
        result = result * 59 + ($totalDebit == null ? 43 : ((Object)$totalDebit).hashCode());
        BigDecimal $totalCredit = this.getTotalCredit();
        result = result * 59 + ($totalCredit == null ? 43 : ((Object)$totalCredit).hashCode());
        return result;
    }
}

