/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.repository;

import de.adorsys.ledgers.postings.db.domain.LedgerAccount;
import de.adorsys.ledgers.postings.db.domain.PostingLine;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

public interface PostingLineRepository
extends PagingAndSortingRepository<PostingLine, String> {
    public List<PostingLine> findByBaseLineAndPstTimeLessThanEqualAndDiscardedTimeIsNullOrderByRecordTimeDesc(String var1, LocalDateTime var2);

    public List<PostingLine> findByAccountAndPstTimeLessThanEqualAndDiscardedTimeIsNullOrderByRecordTimeDesc(LedgerAccount var1, LocalDateTime var2);

    @Query(value="select pl from PostingLine pl join fetch pl.details where pl.account = :account and pl.pstTime > :fromDt and pl.pstTime <= :toDt and pl.discardedTime is null order by pl.pstTime desc")
    public List<PostingLine> findByAccountAndPstTimeGreaterThanAndPstTimeLessThanEqualAndDiscardedTimeIsNullOrderByPstTimeDesc(@Param(value="account") LedgerAccount var1, @Param(value="fromDt") LocalDateTime var2, @Param(value="toDt") LocalDateTime var3);

    @Query(value="select pl from PostingLine pl join pl.details where pl.account = :account and pl.pstTime > :fromDt and pl.pstTime <= :toDt and pl.discardedTime is null order by pl.pstTime desc")
    public Page<PostingLine> findPostingsByAccountAndDates(@Param(value="account") LedgerAccount var1, @Param(value="fromDt") LocalDateTime var2, @Param(value="toDt") LocalDateTime var3, Pageable var4);

    public Optional<PostingLine> findFirstByIdAndAccount(String var1, LedgerAccount var2);
}

