/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EntityListeners;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@MappedSuperclass
@EntityListeners(value={AuditingEntityListener.class})
public abstract class BaseEntity {
    @Id
    private String id;
    @CreatedDate
    @Column(nullable=false, updatable=false)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime created;
    @Column(name="user_details", nullable=false)
    private String userDetails;
    private String shortDesc;
    private String longDesc;

    public BaseEntity() {
    }

    public BaseEntity(String id, LocalDateTime created, String userDetails, String shortDesc, String longDesc) {
        this.id = id;
        this.created = created;
        this.userDetails = userDetails;
        this.shortDesc = shortDesc;
        this.longDesc = longDesc;
    }

    public String getId() {
        return this.id;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public String getUserDetails() {
        return this.userDetails;
    }

    public String getShortDesc() {
        return this.shortDesc;
    }

    public String getLongDesc() {
        return this.longDesc;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public void setUserDetails(String userDetails) {
        this.userDetails = userDetails;
    }

    public void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    public void setLongDesc(String longDesc) {
        this.longDesc = longDesc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseEntity)) {
            return false;
        }
        BaseEntity other = (BaseEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LocalDateTime this$created = this.getCreated();
        LocalDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$userDetails = this.getUserDetails();
        String other$userDetails = other.getUserDetails();
        if (this$userDetails == null ? other$userDetails != null : !this$userDetails.equals(other$userDetails)) {
            return false;
        }
        String this$shortDesc = this.getShortDesc();
        String other$shortDesc = other.getShortDesc();
        if (this$shortDesc == null ? other$shortDesc != null : !this$shortDesc.equals(other$shortDesc)) {
            return false;
        }
        String this$longDesc = this.getLongDesc();
        String other$longDesc = other.getLongDesc();
        return !(this$longDesc == null ? other$longDesc != null : !this$longDesc.equals(other$longDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LocalDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $userDetails = this.getUserDetails();
        result = result * 59 + ($userDetails == null ? 43 : $userDetails.hashCode());
        String $shortDesc = this.getShortDesc();
        result = result * 59 + ($shortDesc == null ? 43 : $shortDesc.hashCode());
        String $longDesc = this.getLongDesc();
        result = result * 59 + ($longDesc == null ? 43 : $longDesc.hashCode());
        return result;
    }
}

