/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import de.adorsys.ledgers.postings.db.domain.FinancialStmt;
import de.adorsys.ledgers.postings.db.domain.LedgerAccount;
import de.adorsys.ledgers.postings.db.domain.PostingTrace;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;

@Entity
public class AccountStmt
extends FinancialStmt {
    @ManyToOne(optional=false)
    private LedgerAccount account;
    @OneToOne
    private PostingTrace youngestPst;
    @Column(nullable=false)
    private BigDecimal totalDebit;
    @Column(nullable=false)
    private BigDecimal totalCredit;

    @PrePersist
    public void prePersist() {
        this.setId(AccountStmt.makeId(this.account, this.getPstTime(), this.getStmtSeqNbr()));
    }

    public final Optional<String> clonedId() {
        return Optional.ofNullable(this.getStmtSeqNbr() <= 0 ? null : AccountStmt.makeId(this.account, this.getPstTime(), this.getStmtSeqNbr() - 1));
    }

    public static String makeId(LedgerAccount account, LocalDateTime pstTime, int stmtSeqNbr) {
        return AccountStmt.makeOperationId(account, pstTime) + "_" + stmtSeqNbr;
    }

    public static String makeOperationId(LedgerAccount account, LocalDateTime pstTime) {
        return account.getId() + "_" + pstTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public LedgerAccount getAccount() {
        return this.account;
    }

    public void setAccount(LedgerAccount account) {
        this.account = account;
    }

    public PostingTrace getYoungestPst() {
        return this.youngestPst;
    }

    public void setYoungestPst(PostingTrace youngestPst) {
        this.youngestPst = youngestPst;
    }

    public BigDecimal getTotalDebit() {
        return this.totalDebit;
    }

    public void setTotalDebit(BigDecimal totalDebit) {
        this.totalDebit = totalDebit;
    }

    public BigDecimal getTotalCredit() {
        return this.totalCredit;
    }

    public void setTotalCredit(BigDecimal totalCredit) {
        this.totalCredit = totalCredit;
    }
}

