/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.ledgers.postings.db.domain.LedgerAccount;
import de.adorsys.ledgers.postings.db.domain.OperationDetails;
import de.adorsys.ledgers.postings.db.domain.Posting;
import de.adorsys.ledgers.postings.db.domain.PostingStatus;
import de.adorsys.ledgers.postings.db.domain.PostingType;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@Entity
public class PostingLine {
    @Id
    private String id;
    @ManyToOne(optional=false)
    private LedgerAccount account;
    @Column(nullable=false, updatable=false)
    private BigDecimal debitAmount;
    @Column(nullable=false, updatable=false)
    private BigDecimal creditAmount;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnore
    private OperationDetails details;
    private String srcAccount;
    private String baseLine;
    private String subOprSrcId;
    @Column(nullable=false, updatable=false)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime recordTime;
    @Column(nullable=false, updatable=false)
    private String oprId;
    private String oprSrc;
    @Column(nullable=false, updatable=false)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime pstTime;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, updatable=false)
    private PostingType pstType;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, updatable=false)
    private PostingStatus pstStatus;
    @Column(nullable=false)
    private String hash;
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime discardedTime;

    public void synchPosting(Posting posting) {
        this.recordTime = posting.getRecordTime();
        this.oprId = posting.getOprId();
        this.pstTime = posting.getPstTime();
        this.pstType = posting.getPstType();
        this.pstStatus = posting.getPstStatus();
        this.hash = posting.getHash();
        this.discardedTime = posting.getDiscardedTime();
        this.oprSrc = posting.getOprSrc();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LedgerAccount getAccount() {
        return this.account;
    }

    public void setAccount(LedgerAccount account) {
        this.account = account;
    }

    public BigDecimal getDebitAmount() {
        return this.debitAmount;
    }

    public void setDebitAmount(BigDecimal debitAmount) {
        this.debitAmount = debitAmount;
    }

    public BigDecimal getCreditAmount() {
        return this.creditAmount;
    }

    public void setCreditAmount(BigDecimal creditAmount) {
        this.creditAmount = creditAmount;
    }

    public OperationDetails getDetails() {
        return this.details;
    }

    public void setDetails(OperationDetails details) {
        this.details = details;
    }

    public String getSrcAccount() {
        return this.srcAccount;
    }

    public void setSrcAccount(String srcAccount) {
        this.srcAccount = srcAccount;
    }

    public String getBaseLine() {
        return this.baseLine;
    }

    public void setBaseLine(String baseLine) {
        this.baseLine = baseLine;
    }

    public String getSubOprSrcId() {
        return this.subOprSrcId;
    }

    public void setSubOprSrcId(String subOprSrcId) {
        this.subOprSrcId = subOprSrcId;
    }

    public LocalDateTime getRecordTime() {
        return this.recordTime;
    }

    public void setRecordTime(LocalDateTime recordTime) {
        this.recordTime = recordTime;
    }

    public String getOprId() {
        return this.oprId;
    }

    public void setOprId(String oprId) {
        this.oprId = oprId;
    }

    public String getOprSrc() {
        return this.oprSrc;
    }

    public void setOprSrc(String oprSrc) {
        this.oprSrc = oprSrc;
    }

    public LocalDateTime getPstTime() {
        return this.pstTime;
    }

    public void setPstTime(LocalDateTime pstTime) {
        this.pstTime = pstTime;
    }

    public PostingType getPstType() {
        return this.pstType;
    }

    public void setPstType(PostingType pstType) {
        this.pstType = pstType;
    }

    public PostingStatus getPstStatus() {
        return this.pstStatus;
    }

    public void setPstStatus(PostingStatus pstStatus) {
        this.pstStatus = pstStatus;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public LocalDateTime getDiscardedTime() {
        return this.discardedTime;
    }

    public void setDiscardedTime(LocalDateTime discardedTime) {
        this.discardedTime = discardedTime;
    }
}

