/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import de.adorsys.ledgers.postings.db.domain.HashRecord;
import de.adorsys.ledgers.postings.db.domain.Ledger;
import de.adorsys.ledgers.postings.db.domain.OperationDetails;
import de.adorsys.ledgers.postings.db.domain.PostingLine;
import de.adorsys.ledgers.postings.db.domain.PostingStatus;
import de.adorsys.ledgers.postings.db.domain.PostingType;
import de.adorsys.ledgers.postings.db.utils.RecordHashHelper;
import de.adorsys.ledgers.util.hash.HashGenerationException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@Entity
@JsonPropertyOrder(alphabetic=true)
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"opr_id", "discarding_id"}, name="Posting_opr_id_discarding_id_unique")})
public class Posting
extends HashRecord {
    private static final RecordHashHelper RECORD_HASH_HELPER = new RecordHashHelper();
    @Id
    private String id;
    @Column(nullable=false, updatable=false)
    private String recordUser;
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime recordTime;
    @Column(nullable=false, updatable=false, name="opr_id")
    private String oprId;
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime oprTime;
    private String oprType;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonIgnore
    private OperationDetails oprDetails;
    private String oprSrc;
    @Column(nullable=false, updatable=false)
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime pstTime;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, updatable=false)
    private PostingType pstType;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, updatable=false)
    private PostingStatus pstStatus = PostingStatus.POSTED;
    @ManyToOne(optional=false)
    private Ledger ledger;
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime valTime;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="posting_id")
    private List<PostingLine> lines = new ArrayList<PostingLine>();
    private String discardedId;
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime discardedTime;
    @Column(name="discarding_id")
    private String discardingId;

    public Posting hash() {
        if (this.hash != null) {
            return this;
        }
        if (this.recordTime == null) {
            this.recordTime = LocalDateTime.now();
        }
        try {
            this.hash = RECORD_HASH_HELPER.computeRecHash(this);
        }
        catch (HashGenerationException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public void synchLines() {
        this.lines.forEach(l -> l.synchPosting(this));
    }

    public String getId() {
        return this.id;
    }

    public String getRecordUser() {
        return this.recordUser;
    }

    public LocalDateTime getRecordTime() {
        return this.recordTime;
    }

    public String getOprId() {
        return this.oprId;
    }

    public LocalDateTime getOprTime() {
        return this.oprTime;
    }

    public String getOprType() {
        return this.oprType;
    }

    public OperationDetails getOprDetails() {
        return this.oprDetails;
    }

    public LocalDateTime getPstTime() {
        return this.pstTime;
    }

    public PostingType getPstType() {
        return this.pstType;
    }

    public PostingStatus getPstStatus() {
        return this.pstStatus;
    }

    public Ledger getLedger() {
        return this.ledger;
    }

    public LocalDateTime getValTime() {
        return this.valTime;
    }

    public List<PostingLine> getLines() {
        return this.lines;
    }

    public String getOprSrc() {
        return this.oprSrc;
    }

    public String getDiscardedId() {
        return this.discardedId;
    }

    public void setDiscardedId(String discardedId) {
        this.discardedId = discardedId;
    }

    public LocalDateTime getDiscardedTime() {
        return this.discardedTime;
    }

    public void setDiscardedTime(LocalDateTime discardedTime) {
        this.discardedTime = discardedTime;
    }

    public String getDiscardingId() {
        return this.discardingId;
    }

    public void setDiscardingId(String discardingId) {
        this.discardingId = discardingId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRecordUser(String recordUser) {
        this.recordUser = recordUser;
    }

    public void setRecordTime(LocalDateTime recordTime) {
        this.recordTime = recordTime;
    }

    public void setOprId(String oprId) {
        this.oprId = oprId;
    }

    public void setOprTime(LocalDateTime oprTime) {
        this.oprTime = oprTime;
    }

    public void setOprType(String oprType) {
        this.oprType = oprType;
    }

    public void setOprDetails(OperationDetails oprDetails) {
        this.oprDetails = oprDetails;
    }

    public void setOprSrc(String oprSrc) {
        this.oprSrc = oprSrc;
    }

    public void setPstTime(LocalDateTime pstTime) {
        this.pstTime = pstTime;
    }

    public void setPstType(PostingType pstType) {
        this.pstType = pstType;
    }

    public void setPstStatus(PostingStatus pstStatus) {
        this.pstStatus = pstStatus;
    }

    public void setLedger(Ledger ledger) {
        this.ledger = ledger;
    }

    public void setValTime(LocalDateTime valTime) {
        this.valTime = valTime;
    }

    public void setLines(List<PostingLine> lines) {
        this.lines = lines;
    }
}

