/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import de.adorsys.ledgers.postings.db.domain.FinancialStmt;
import de.adorsys.ledgers.postings.db.domain.Ledger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;

@Entity
public class LedgerStmt
extends FinancialStmt {
    @ManyToOne(optional=false)
    private Ledger ledger;

    @PrePersist
    public void prePersist() {
        this.setId(LedgerStmt.makeId(this.ledger, this.getPstTime(), this.getStmtSeqNbr()));
    }

    public final Optional<String> clonedId() {
        return Optional.ofNullable(this.getStmtSeqNbr() <= 0 ? null : LedgerStmt.makeId(this.ledger, this.getPstTime(), this.getStmtSeqNbr() - 1));
    }

    public static String makeId(Ledger ledger, LocalDateTime pstTime, int stmtSeqNbr) {
        return LedgerStmt.makeOperationId(ledger, pstTime) + "_" + stmtSeqNbr;
    }

    public static String makeOperationId(Ledger ledger, LocalDateTime pstTime) {
        return ledger.getId() + "_" + pstTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public Ledger getLedger() {
        return this.ledger;
    }

    public void setLedger(Ledger ledger) {
        this.ledger = ledger;
    }
}

