/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import de.adorsys.ledgers.postings.db.domain.AccountCategory;
import de.adorsys.ledgers.postings.db.domain.BalanceSide;
import de.adorsys.ledgers.postings.db.domain.ChartOfAccount;
import de.adorsys.ledgers.postings.db.domain.Ledger;
import de.adorsys.ledgers.postings.db.domain.NamedEntity;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"ledger_id", "name"}, name="LedgerAccount_ledger_id_name_unique")})
public class LedgerAccount
extends NamedEntity {
    @ManyToOne(optional=false)
    private Ledger ledger;
    @ManyToOne(optional=true)
    private LedgerAccount parent;
    @ManyToOne(optional=false)
    private ChartOfAccount coa;
    @Column(nullable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    private BalanceSide balanceSide;
    @Column(nullable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    private AccountCategory category;

    public LedgerAccount(String id, LocalDateTime created, String user, String shortDesc, String longDesc, String name, Ledger ledger, LedgerAccount parent, ChartOfAccount coa, BalanceSide balanceSide, AccountCategory category) {
        super(id, created, user, shortDesc, longDesc, name);
        this.ledger = ledger;
        this.parent = parent;
        this.coa = coa;
        this.balanceSide = balanceSide;
        this.category = category;
    }

    public LedgerAccount() {
    }

    public Ledger getLedger() {
        return this.ledger;
    }

    public LedgerAccount getParent() {
        return this.parent;
    }

    public ChartOfAccount getCoa() {
        return this.coa;
    }

    public BalanceSide getBalanceSide() {
        return this.balanceSide;
    }

    public AccountCategory getCategory() {
        return this.category;
    }

    @Override
    public String toString() {
        return "LedgerAccount [ledger=" + this.ledger + ", parent=" + this.parent + ", coa=" + this.coa + ", balanceSide=" + (Object)((Object)this.balanceSide) + ", category=" + (Object)((Object)this.category) + "] [super: " + super.toString() + "]";
    }
}

