/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import de.adorsys.ledgers.postings.db.domain.Posting;
import de.adorsys.ledgers.postings.db.domain.PostingTrace;
import de.adorsys.ledgers.postings.db.domain.StmtStatus;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@MappedSuperclass
public abstract class FinancialStmt {
    @Id
    private String id;
    @OneToOne
    private Posting posting;
    @Column(nullable=false, updatable=false)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime pstTime;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, updatable=false)
    private StmtStatus stmtStatus;
    @OneToOne
    private PostingTrace latestPst;
    @Column(nullable=false, updatable=false)
    private int stmtSeqNbr = 0;

    public LocalDateTime getPstTime() {
        return this.pstTime;
    }

    public int getStmtSeqNbr() {
        return this.stmtSeqNbr;
    }

    public String getId() {
        return this.id;
    }

    public StmtStatus getStmtStatus() {
        return this.stmtStatus;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPstTime(LocalDateTime pstTime) {
        this.pstTime = pstTime;
    }

    public void setStmtStatus(StmtStatus stmtStatus) {
        this.stmtStatus = stmtStatus;
    }

    public void setStmtSeqNbr(int stmtSeqNbr) {
        this.stmtSeqNbr = stmtSeqNbr;
    }

    public PostingTrace getLatestPst() {
        return this.latestPst;
    }

    public void setLatestPst(PostingTrace latestPst) {
        this.latestPst = latestPst;
    }

    public Posting getPosting() {
        return this.posting;
    }

    public void setPosting(Posting posting) {
        this.posting = posting;
    }
}

