/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.db.domain;

import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EntityListeners;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@MappedSuperclass
@EntityListeners(value={AuditingEntityListener.class})
public abstract class BaseEntity {
    @Id
    private String id;
    @CreatedDate
    @Column(nullable=false, updatable=false)
    @Convert(converter=Jsr310JpaConverters.LocalDateTimeConverter.class)
    private LocalDateTime created;
    @Column(name="user_details", nullable=false)
    private String userDetails;
    private String shortDesc;
    private String longDesc;

    public BaseEntity() {
    }

    public BaseEntity(String id, LocalDateTime created, String userDetails, String shortDesc, String longDesc) {
        this.id = id;
        this.created = created;
        this.userDetails = userDetails;
        this.shortDesc = shortDesc;
        this.longDesc = longDesc;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public String getUserDetails() {
        return this.userDetails;
    }

    public void setUserDetails(String userDetails) {
        this.userDetails = userDetails;
    }

    public String getShortDesc() {
        return this.shortDesc;
    }

    public void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    public String getLongDesc() {
        return this.longDesc;
    }

    public void setLongDesc(String longDesc) {
        this.longDesc = longDesc;
    }

    public String toString() {
        return "BaseEntity [id=" + this.id + ", created=" + this.created + ", userDetails=" + this.userDetails + ", shortDesc=" + this.shortDesc + ", longDesc=" + this.longDesc + "]";
    }
}

