/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.mockbank.simple.service;

import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.AppMgmtRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.middleware.rest.exception.ConflictRestException;
import de.adorsys.ledgers.middleware.rest.exception.ForbiddenRestException;
import de.adorsys.ledgers.middleware.rest.exception.NotFoundRestException;
import de.adorsys.ledgers.mockbank.simple.service.AdminPayload;
import de.adorsys.ledgers.mockbank.simple.service.AuthCodeReader;
import de.adorsys.ledgers.mockbank.simple.service.UserContext;
import de.adorsys.ledgers.mockbank.simple.service.UserContextService;
import feign.FeignException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UserAccountService {
    @Autowired
    private AppMgmtRestClient ledgersAppMgmt;
    @Autowired
    private UserMgmtRestClient ledgersUserMgmt;
    @Autowired
    private UserContextService contextService;
    @Autowired
    private AuthCodeReader authCodeReader;

    public BearerTokenTO authorize(String login, String pin, UserRoleTO role) throws UnsupportedEncodingException, IOException, ProtocolException {
        ResponseEntity res = null;
        HttpStatus statusCode = null;
        try {
            res = this.ledgersUserMgmt.authorise(login, pin, role);
            statusCode = res.getStatusCode();
        }
        catch (FeignException f) {
            statusCode = HttpStatus.valueOf((int)f.status());
        }
        if (res != null && HttpStatus.OK.equals((Object)statusCode)) {
            SCALoginResponseTO scaLoginResponseTO = (SCALoginResponseTO)res.getBody();
            UserContext bag = this.updateBag(login, scaLoginResponseTO.getBearerToken());
            ScaStatusTO scaStatus = scaLoginResponseTO.getScaStatus();
            if (ScaStatusTO.EXEMPTED.equals((Object)scaStatus) || ScaStatusTO.PSUAUTHENTICATED.equals((Object)scaStatus)) {
                return scaLoginResponseTO.getBearerToken();
            }
            if (ScaStatusTO.PSUIDENTIFIED.equals((Object)scaStatus)) {
                ScaUserDataTO scaMethod = (ScaUserDataTO)scaLoginResponseTO.getScaMethods().iterator().next();
                return this.selectSCA(bag, scaLoginResponseTO, scaMethod.getId());
            }
            if (ScaStatusTO.SCAMETHODSELECTED.equals((Object)scaStatus)) {
                return this.authoriseLogin(bag, scaLoginResponseTO, this.authCodeReader.readAuthCode(scaLoginResponseTO.getScaId(), scaLoginResponseTO.getAuthorisationId()));
            }
            throw new IOException(String.format("Unidentified state after select sca. SacStatus %s. User massage %s", scaLoginResponseTO.getScaStatus(), scaLoginResponseTO.getPsuMessage()));
        }
        if (HttpStatus.FORBIDDEN.equals((Object)statusCode)) {
            throw new ForbiddenRestException(String.format("User with login %s has not access with role %s", login, role.name()));
        }
        if (HttpStatus.NOT_FOUND.equals((Object)statusCode)) {
            throw new NotFoundRestException(String.format("User with login %s not found", login));
        }
        throw new IOException(String.format("Error authorizing admin user responseCode %s message %s.", statusCode.value(), Optional.ofNullable(res).map(ResponseEntity::getStatusCode).orElse(HttpStatus.INTERNAL_SERVER_ERROR)));
    }

    private BearerTokenTO authoriseLogin(UserContext bag, SCALoginResponseTO scaLoginResponseTO, String authCode) throws IOException {
        try {
            this.contextService.setContext(bag);
            bag.setAccessToken(scaLoginResponseTO.getBearerToken());
            BearerTokenTO bearerTokenTO = ((SCALoginResponseTO)this.ledgersUserMgmt.authorizeLogin(scaLoginResponseTO.getScaId(), scaLoginResponseTO.getAuthorisationId(), authCode).getBody()).getBearerToken();
            return bearerTokenTO;
        }
        catch (FeignException f) {
            throw new IOException(String.format("Error authorizing login: responseCode %s message %s.", f.status(), f.getMessage()));
        }
        finally {
            this.contextService.unsetContext();
        }
    }

    private BearerTokenTO selectSCA(UserContext bag, SCALoginResponseTO scaLoginResponseTO, String scaMethodId) throws IOException {
        try {
            this.contextService.setContext(bag);
            bag.setAccessToken(scaLoginResponseTO.getBearerToken());
            SCALoginResponseTO scaResponse = (SCALoginResponseTO)this.ledgersUserMgmt.selectMethod(scaLoginResponseTO.getScaId(), scaLoginResponseTO.getAuthorisationId(), scaMethodId).getBody();
            ScaStatusTO scaSelectStatus = scaResponse.getScaStatus();
            if (ScaStatusTO.SCAMETHODSELECTED.equals((Object)scaSelectStatus)) {
                BearerTokenTO bearerTokenTO = this.authoriseLogin(bag, scaResponse, this.authCodeReader.readAuthCode(scaResponse.getScaId(), scaResponse.getAuthorisationId()));
                return bearerTokenTO;
            }
            try {
                throw new IOException(String.format("Unidentified state after select sca. SacStatus %s. User massage %s", scaLoginResponseTO.getScaStatus(), scaLoginResponseTO.getPsuMessage()));
            }
            catch (FeignException f) {
                throw new IOException(String.format("Error creating admin user responseCode %s message %s.", f.status(), f.getMessage()));
            }
        }
        finally {
            this.contextService.unsetContext();
        }
    }

    public BearerTokenTO authorizeAdmin() throws IOException {
        UserTO adminUser = AdminPayload.adminUser();
        this.contextService.updateCredentials(adminUser.getLogin(), new UserContext(adminUser));
        try {
            return this.authorize(adminUser.getLogin(), adminUser.getPin(), UserRoleTO.SYSTEM);
        }
        catch (ForbiddenRestException e) {
            throw new IllegalStateException(e);
        }
    }

    public BearerTokenTO createAdminAccount() throws IOException, ConflictRestException {
        try {
            UserTO adminUser = AdminPayload.adminUser();
            this.contextService.updateCredentials(adminUser.getLogin(), new UserContext(adminUser));
            BearerTokenTO accessToken = (BearerTokenTO)this.ledgersAppMgmt.admin(adminUser).getBody();
            this.updateBag(adminUser.getLogin(), accessToken);
            return accessToken;
        }
        catch (FeignException f) {
            HttpStatus statusCode = HttpStatus.valueOf((int)f.status());
            if (HttpStatus.CONFLICT.equals((Object)statusCode)) {
                throw new ConflictRestException("Admin account exists. No need to create");
            }
            throw new IOException(String.format("Error creating admin user responseCode %s message %s.", statusCode.value(), statusCode));
        }
    }

    private UserContext updateBag(String login, BearerTokenTO accessToken) {
        UserContext bag = this.contextService.byLoginOrEx(login);
        bag.setAccessToken(accessToken);
        this.contextService.updateCredentials(login, bag);
        return bag;
    }

    public BearerTokenTO authOrCreateCustomer(UserTO user) throws UnsupportedEncodingException, ProtocolException, IOException {
        this.contextService.updateCredentials(user.getLogin(), new UserContext(user));
        try {
            return this.authorize(user.getLogin(), user.getPin(), UserRoleTO.CUSTOMER);
        }
        catch (ForbiddenRestException | NotFoundRestException e) {
            return this.registerCustomer(user);
        }
    }

    private BearerTokenTO registerCustomer(UserTO user) throws ProtocolException, IOException {
        try {
            this.ledgersUserMgmt.register(user.getLogin(), user.getEmail(), user.getPin(), UserRoleTO.CUSTOMER);
            try {
                return this.authorize(user.getLogin(), user.getPin(), UserRoleTO.CUSTOMER);
            }
            catch (ForbiddenRestException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        catch (FeignException f) {
            HttpStatus statusCode = HttpStatus.valueOf((int)f.status());
            throw new IOException(String.format("Error registering customer responseCode %s message %s.", statusCode.value(), statusCode));
        }
    }

    public void updateScaMethods(UserTO userTO) throws IOException {
        try {
            this.contextService.setContextFromLogin(userTO.getLogin());
            UserTO persistent = (UserTO)this.ledgersUserMgmt.getUser().getBody();
            List persistentScaUserData = persistent.getScaUserData();
            List scaUserData = userTO.getScaUserData();
            ArrayList toCreateScaUserData = new ArrayList(scaUserData);
            ArrayList unchangedScaUserData = new ArrayList();
            if (scaUserData != null) {
                scaUserData.forEach(s -> persistentScaUserData.stream().filter(a -> a.getScaMethod().equals((Object)s.getScaMethod()) && a.getMethodValue().equals(s.getMethodValue())).findFirst().ifPresent(u -> {
                    unchangedScaUserData.add(u);
                    toCreateScaUserData.remove(s);
                }));
            }
            unchangedScaUserData.addAll(toCreateScaUserData);
            this.ledgersUserMgmt.updateUserScaData(unchangedScaUserData);
        }
        catch (FeignException f) {
            throw new IOException(String.format("Error updating sca data responseCode %s message %s.", f.status(), f.getMessage()));
        }
        finally {
            this.contextService.unsetContext();
        }
    }
}

