/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.mockbank.simple.service;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.AppMgmtRestClient;
import de.adorsys.ledgers.middleware.rest.exception.ConflictRestException;
import de.adorsys.ledgers.mockbank.simple.data.MockbankInitData;
import de.adorsys.ledgers.mockbank.simple.data.TransactionData;
import de.adorsys.ledgers.mockbank.simple.service.AccountTransactionService;
import de.adorsys.ledgers.mockbank.simple.service.DepositAccountService;
import de.adorsys.ledgers.mockbank.simple.service.PaymentProcessingService;
import de.adorsys.ledgers.mockbank.simple.service.UserAccountService;
import de.adorsys.ledgers.mockbank.simple.service.UserContext;
import de.adorsys.ledgers.mockbank.simple.service.UserContextService;
import feign.FeignException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class MockBankSimpleInitService {
    private boolean initialized = false;
    @Autowired
    private AppMgmtRestClient ledgersAppMgmt;
    @Autowired
    private UserContextService contextService;
    @Autowired
    private MockbankInitData sampleData;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private PaymentProcessingService paymentProcessingService;
    @Autowired
    private AccountTransactionService accountTransactionService;
    @Autowired
    private DepositAccountService depositAccountService;

    public void runInit() {
        try {
            BearerTokenTO bearerToken = null;
            try {
                bearerToken = this.userAccountService.createAdminAccount();
            }
            catch (ConflictRestException c) {
                bearerToken = this.userAccountService.authorizeAdmin();
            }
            this.initLedgers(bearerToken);
            this.updateIfRequired();
            if (this.verifyUpload(false)) {
                this.initialized = true;
                return;
            }
            this.paymentProcessingService.processSinglePayments();
            this.paymentProcessingService.processBulkPayments();
            this.initialized = true;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private boolean verifyUpload(boolean strict) {
        boolean valid = true;
        List<TransactionData> transactions = this.sampleData.getTransactions();
        for (TransactionData t : transactions) {
            try {
                valid = valid && this.accountTransactionService.validateTransactions(t, strict);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLedgers(BearerTokenTO accessToken) throws IOException {
        try {
            UserContext adminBag = this.contextService.newToken(accessToken);
            this.contextService.setContext(adminBag);
            HttpStatus status = null;
            try {
                ResponseEntity initApp = this.ledgersAppMgmt.initApp();
                status = initApp.getStatusCode();
            }
            catch (FeignException f) {
                status = HttpStatus.valueOf((int)f.status());
            }
            if (!HttpStatus.OK.equals((Object)status)) {
                throw new IOException(String.format("Error initializing ledger user responseCode %s message %s.", status.value(), status.toString()));
            }
        }
        finally {
            this.contextService.unsetContext();
        }
    }

    private void updateIfRequired() throws IOException {
        if (this.sampleData.getUsers() == null || this.sampleData.getUsers().isEmpty()) {
            return;
        }
        List<AccountDetailsTO> accounts = this.sampleData.getAccounts();
        List<UserTO> users = this.sampleData.getUsers();
        for (UserTO userTO : users) {
            BearerTokenTO accessToken = this.userAccountService.authOrCreateCustomer(userTO);
            UserContext bag = new UserContext(userTO, accessToken);
            this.contextService.updateCredentials(userTO.getLogin(), bag);
            this.userAccountService.updateScaMethods(userTO);
            List<AccountDetailsTO> accessibleAccounts = this.depositAccountService.accessibleAccounts(bag);
            bag.getAccessibleAccounts().addAll(accessibleAccounts);
            this.contextService.updateCredentials(userTO.getLogin(), bag);
            List accessibleAccountsFromDBIbans = accessibleAccounts.stream().map(AccountDetailsTO::getIban).collect(Collectors.toList());
            List accessibleAccountsFromFileIbans = userTO.getAccountAccesses().stream().map(AccountAccessTO::getIban).collect(Collectors.toList());
            for (AccountDetailsTO accountDetailsTO : accounts) {
                if (!accessibleAccountsFromFileIbans.contains(accountDetailsTO.getIban()) || accessibleAccountsFromDBIbans.contains(accountDetailsTO.getIban())) continue;
                this.depositAccountService.createDepositAccount(userTO, accountDetailsTO);
            }
        }
    }

    public boolean checkInitialized() {
        return this.initialized;
    }
}

