/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.mockbank.simple.service;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.client.rest.AccountRestClient;
import de.adorsys.ledgers.mockbank.simple.data.TransactionData;
import de.adorsys.ledgers.mockbank.simple.service.DepositAccountService;
import de.adorsys.ledgers.mockbank.simple.service.MockBankSimpleInitService;
import de.adorsys.ledgers.mockbank.simple.service.UserContextService;
import feign.FeignException;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountTransactionService {
    private static final Logger logger = LoggerFactory.getLogger(MockBankSimpleInitService.class);
    @Autowired
    private AccountRestClient ledgersAccount;
    @Autowired
    private UserContextService contextService;
    @Autowired
    private DepositAccountService depositAccountService;

    public boolean validateTransactions(TransactionData t, boolean strict) throws IOException {
        AccountDetailsTO accountDetailsTO = this.depositAccountService.account(t.getIban()).orElseThrow(() -> this.depositAccountService.numberFormater(t.getIban()));
        List<TransactionTO> loadedTransactions = this.loadTransactions(accountDetailsTO, t.getDateFrom(), LocalDate.now());
        List<TransactionTO> expectedTransactions = t.getTransactions();
        if (loadedTransactions.size() < expectedTransactions.size() || strict && loadedTransactions.size() != expectedTransactions.size()) {
            logger.error("For account {} loaded transactions of size {} differs from configured transactions of size {}.", new Object[]{t.getIban(), loadedTransactions.size(), expectedTransactions.size()});
            return false;
        }
        boolean good = this.stripExpectedTransactions(loadedTransactions, expectedTransactions);
        if (!good) {
            return false;
        }
        if (strict && !loadedTransactions.isEmpty()) {
            for (TransactionTO lt : loadedTransactions) {
                logger.error("Loaded transaction not specified: date {} and amount {} and creditor {}", new Object[]{lt.getBookingDate(), lt.getAmount().getAmount(), lt.getCreditorName()});
            }
            logger.error("Logged transactions are not supposed to be present in the database.");
            return false;
        }
        return true;
    }

    private boolean stripExpectedTransactions(List<TransactionTO> loadedTransactions, List<TransactionTO> expectedTransactions) {
        for (int i = 0; i < expectedTransactions.size(); ++i) {
            TransactionTO expectedTransaction = expectedTransactions.get(i);
            TransactionTO transactionTO = this.hasLoadedTransaction(expectedTransaction, loadedTransactions);
            if (transactionTO == null) {
                logger.error("Missing transaction with: date {} and amount {} and creditor {}", new Object[]{expectedTransaction.getBookingDate(), expectedTransaction.getAmount().getAmount(), expectedTransaction.getCreditorName()});
                return false;
            }
            loadedTransactions.remove(transactionTO);
        }
        return true;
    }

    private List<TransactionTO> loadTransactions(AccountDetailsTO accountDetailsTO, LocalDate from, LocalDate to) throws IOException {
        AccountDetailsTO account = this.depositAccountService.account(accountDetailsTO.getIban()).orElseThrow(() -> this.depositAccountService.numberFormater(accountDetailsTO.getIban()));
        try {
            this.contextService.setContextFromIban(accountDetailsTO.getIban());
            List list = (List)this.ledgersAccount.getTransactionByDates(account.getId(), from, to).getBody();
            return list;
        }
        catch (FeignException f) {
            throw new IOException(String.format("Error loading transaction for account %s responseCode %s message %s.", accountDetailsTO.getIban(), f.status(), f.getMessage()));
        }
        finally {
            this.contextService.unsetContext();
        }
    }

    private TransactionTO hasLoadedTransaction(TransactionTO expectedTx, List<TransactionTO> loadedTransactions) {
        return loadedTransactions.stream().filter(loadedTx -> this.matchTx(expectedTx, (TransactionTO)loadedTx)).findFirst().orElse(null);
    }

    private boolean matchTx(TransactionTO expectedTransaction, TransactionTO loadedTransaction) {
        return expectedTransaction.getBookingDate().equals(loadedTransaction.getBookingDate()) && expectedTransaction.getAmount().getAmount().compareTo(loadedTransaction.getAmount().getAmount()) == 0 && StringUtils.equals((CharSequence)expectedTransaction.getCreditorName(), (CharSequence)loadedTransaction.getCreditorName());
    }
}

