/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.mockbank.simple.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.client.rest.AccountRestClient;
import de.adorsys.ledgers.middleware.client.rest.PaymentRestClient;
import de.adorsys.ledgers.mockbank.simple.data.BulkPaymentsData;
import de.adorsys.ledgers.mockbank.simple.data.MockbankInitData;
import de.adorsys.ledgers.mockbank.simple.data.SinglePaymentsData;
import de.adorsys.ledgers.mockbank.simple.service.AuthCodeReader;
import de.adorsys.ledgers.mockbank.simple.service.DepositAccountService;
import de.adorsys.ledgers.mockbank.simple.service.UserContext;
import de.adorsys.ledgers.mockbank.simple.service.UserContextService;
import feign.FeignException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.time.LocalDate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentProcessingService {
    @Autowired
    private AccountRestClient ledgersAccount;
    @Autowired
    private PaymentRestClient ledgersPayment;
    @Autowired
    private UserContextService contextService;
    @Autowired
    private MockbankInitData sampleData;
    @Autowired
    private DepositAccountService depositAccountService;
    @Autowired
    private AuthCodeReader authCodeReader;

    public void processSinglePayments() throws IOException {
        List<SinglePaymentsData> singlePayments = this.sampleData.getSinglePayments();
        if (singlePayments == null) {
            return;
        }
        for (SinglePaymentsData singlePaymentData : singlePayments) {
            SinglePaymentTO pymt = singlePaymentData.getSinglePayment();
            String iban = pymt.getDebtorAccount().getIban();
            this.execPayment(pymt, iban, PaymentTypeTO.SINGLE, pymt.getEndToEndIdentification(), pymt.getRequestedExecutionDate());
        }
    }

    public void processBulkPayments() throws IOException {
        List<BulkPaymentsData> bulkPaymentTests = this.sampleData.getBulkPayments();
        if (bulkPaymentTests == null) {
            return;
        }
        for (BulkPaymentsData bulkPaymentData : bulkPaymentTests) {
            BulkPaymentTO pymt = bulkPaymentData.getBulkPayment();
            String endToEndIdentification = ((SinglePaymentTO)pymt.getPayments().iterator().next()).getEndToEndIdentification();
            String iban = pymt.getDebtorAccount().getIban();
            this.execPayment(pymt, iban, PaymentTypeTO.BULK, endToEndIdentification, pymt.getRequestedExecutionDate());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execPayment(Object payment, String iban, PaymentTypeTO pymentType, String end2EndId, LocalDate execDate) throws MalformedURLException, IOException, ProtocolException, JsonParseException, JsonMappingException {
        SCAPaymentResponseTO response;
        ScaStatusTO scaInitStatus;
        UserContext bag = this.contextService.bagByIbanOrEx(iban);
        AccountDetailsTO accountDetails = this.depositAccountService.account(iban).orElseThrow(() -> this.depositAccountService.numberFormater(iban));
        List<TransactionTO> transactions = this.transactions(execDate, accountDetails);
        if (this.containsPayment(end2EndId, transactions) || ScaStatusTO.EXEMPTED.equals((Object)(scaInitStatus = (response = this.initiatePymt(bag, payment, pymentType)).getScaStatus()))) return;
        if (ScaStatusTO.SCAMETHODSELECTED.equals((Object)scaInitStatus)) {
            this.authorisePayment(bag, response, this.authCodeReader.readAuthCode(response.getPaymentId(), response.getAuthorisationId()));
            return;
        } else {
            if (!ScaStatusTO.PSUIDENTIFIED.equals((Object)scaInitStatus) && !ScaStatusTO.PSUAUTHENTICATED.equals((Object)scaInitStatus)) throw new IOException(String.format("Unidentified state after init payment. SacStatus %s. Payment status %s. User massage %s", response.getScaStatus(), response.getTransactionStatus(), response.getPsuMessage()));
            ScaUserDataTO scaMethod = (ScaUserDataTO)response.getScaMethods().iterator().next();
            SCAPaymentResponseTO scaResponse = this.selectSCA(bag, response, scaMethod.getId());
            ScaStatusTO scaSelectStatus = scaResponse.getScaStatus();
            if (!ScaStatusTO.SCAMETHODSELECTED.equals((Object)scaSelectStatus)) throw new IOException(String.format("Unidentified state after select sca. SacStatus %s. Payment status %s. User massage %s", response.getScaStatus(), response.getTransactionStatus(), response.getPsuMessage()));
            this.authorisePayment(bag, response, this.authCodeReader.readAuthCode(response.getPaymentId(), response.getAuthorisationId()));
        }
    }

    private boolean containsPayment(String endToEndIdentification, List<TransactionTO> transactions) {
        return endToEndIdentification != null && transactions.stream().filter(t -> endToEndIdentification.equals(t.getEndToEndId())).findFirst().isPresent();
    }

    private List<TransactionTO> transactions(LocalDate execDate, AccountDetailsTO accountDetails) throws IOException {
        try {
            this.contextService.setContextFromIban(accountDetails.getIban());
            List list = (List)this.ledgersAccount.getTransactionByDates(accountDetails.getId(), execDate, LocalDate.now()).getBody();
            return list;
        }
        catch (FeignException f) {
            throw new IOException(String.format("Error initiating payment: responseCode %s message %s.", f.status(), f.getMessage()));
        }
        finally {
            this.contextService.unsetContext();
        }
    }

    private SCAPaymentResponseTO initiatePymt(UserContext bag, Object payment, PaymentTypeTO paymentTypeTO) throws IOException {
        try {
            this.contextService.setContext(bag);
            SCAPaymentResponseTO sCAPaymentResponseTO = (SCAPaymentResponseTO)this.ledgersPayment.initiatePayment(paymentTypeTO, payment).getBody();
            return sCAPaymentResponseTO;
        }
        catch (FeignException f) {
            throw new IOException(String.format("Error initiating payment: responseCode %s message %s.", f.status(), f.getMessage()));
        }
        finally {
            this.contextService.unsetContext();
        }
    }

    private SCAPaymentResponseTO selectSCA(UserContext bag, SCAPaymentResponseTO paymentResponse, String scaMethodId) throws IOException {
        try {
            this.contextService.setContext(bag);
            SCAPaymentResponseTO sCAPaymentResponseTO = (SCAPaymentResponseTO)this.ledgersPayment.selectMethod(paymentResponse.getPaymentId(), paymentResponse.getAuthorisationId(), scaMethodId).getBody();
            return sCAPaymentResponseTO;
        }
        catch (FeignException f) {
            throw new IOException(String.format("Error selecting sca method: responseCode %s message %s.", f.status(), f.getMessage()));
        }
        finally {
            this.contextService.unsetContext();
        }
    }

    private SCAPaymentResponseTO authorisePayment(UserContext bag, SCAPaymentResponseTO paymentResponse, String authCode) throws IOException {
        try {
            this.contextService.setContext(bag);
            SCAPaymentResponseTO sCAPaymentResponseTO = (SCAPaymentResponseTO)this.ledgersPayment.authorizePayment(paymentResponse.getPaymentId(), paymentResponse.getAuthorisationId(), authCode).getBody();
            return sCAPaymentResponseTO;
        }
        catch (FeignException f) {
            throw new IOException(String.format("Error authorizing payment: responseCode %s message %s.", f.status(), f.getMessage()));
        }
        finally {
            this.contextService.unsetContext();
        }
    }
}

