/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.mockbank.simple.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.AccountRestClient;
import de.adorsys.ledgers.mockbank.simple.service.UserAccountService;
import de.adorsys.ledgers.mockbank.simple.service.UserContext;
import de.adorsys.ledgers.mockbank.simple.service.UserContextService;
import feign.FeignException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DepositAccountService {
    @Autowired
    private AccountRestClient ledgersAccount;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private UserContextService contextService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDepositAccount(UserTO userTO, AccountDetailsTO accountDetailsTO) throws JsonProcessingException, MalformedURLException, IOException, ProtocolException, UnsupportedEncodingException {
        block7: {
            UserContext userContenxt = this.contextService.byLoginOrEx(userTO.getLogin());
            List<AccountDetailsTO> accessibleAccounts = this.accessibleAccounts(userContenxt);
            for (AccountDetailsTO myAccount : accessibleAccounts) {
                if (!StringUtils.equals((CharSequence)myAccount.getIban(), (CharSequence)accountDetailsTO.getIban())) continue;
                return;
            }
            try {
                HttpStatus statusCode;
                this.contextService.setContext(userContenxt);
                try {
                    ResponseEntity res = this.ledgersAccount.createDepositAccount(accountDetailsTO);
                    statusCode = res.getStatusCode();
                }
                catch (FeignException f) {
                    statusCode = HttpStatus.valueOf((int)f.status());
                }
                if (HttpStatus.OK.equals((Object)statusCode) || HttpStatus.CONFLICT.equals((Object)statusCode)) {
                    BearerTokenTO accessToken = this.userAccountService.authorize(userTO.getLogin(), userTO.getPin(), UserRoleTO.CUSTOMER);
                    UserContext bag = this.contextService.bagByIbanOrEx(accountDetailsTO.getIban());
                    bag.setAccessToken(accessToken);
                    break block7;
                }
                throw new IOException(String.format("Error creating account responseCode %s message %s.", statusCode.value(), statusCode));
            }
            finally {
                this.contextService.unsetContext();
            }
        }
    }

    public List<AccountDetailsTO> accessibleAccounts(UserContext userBag) throws MalformedURLException, IOException, ProtocolException, JsonParseException, JsonMappingException {
        try {
            this.contextService.setContext(userBag);
            List list = (List)this.ledgersAccount.getListOfAccounts().getBody();
            return list;
        }
        catch (FeignException f) {
            throw new IOException(String.format("Error creating admin user responseCode %s message %s.", f.status(), f.getMessage()));
        }
        finally {
            this.contextService.unsetContext();
        }
    }

    public Optional<AccountDetailsTO> account(String iban) throws MalformedURLException, IOException, ProtocolException, JsonParseException, JsonMappingException {
        try {
            this.contextService.setContextFromIban(iban);
            Optional<Object> optional = Optional.ofNullable(this.ledgersAccount.getAccountDetailsByIban(iban).getBody());
            return optional;
        }
        catch (FeignException f) {
            HttpStatus statusCode = HttpStatus.valueOf((int)f.status());
            if (HttpStatus.NOT_FOUND.equals((Object)statusCode)) {
                Optional<AccountDetailsTO> optional = Optional.empty();
                return optional;
            }
            throw new IOException(String.format("Error reading account details responseCode %s message %s.", f.status(), f.getMessage()));
        }
        finally {
            this.contextService.unsetContext();
        }
    }

    public IOException numberFormater(String iban) {
        return new IOException(String.format("Deposit account with iban %s not found.", iban));
    }
}

