/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.mockbank.simple.data.test;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.adorsys.ledgers.deposit.api.service.domain.ASPSPConfigSource;
import de.adorsys.ledgers.middleware.api.exception.AccountNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.AccountWithPrefixGoneMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.AccountWithSuffixExistsMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.InsufficientPermissionMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.PaymentProcessingMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserAlreadyExistsMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserNotFoundMiddlewareException;
import de.adorsys.ledgers.mockbank.simple.data.MockbankInitData;
import de.adorsys.ledgers.mockbank.simple.data.test.MockBankConfigSource;
import de.adorsys.ledgers.mockbank.simple.data.test.MockBankSimpleDataTestBasePackage;
import de.adorsys.ledgers.mockbank.simple.data.test.api.DataUploadService;
import de.adorsys.ledgers.mockbank.simple.data.test.impl.DataUploadServiceImpl;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ComponentScan(basePackageClasses={MockBankSimpleDataTestBasePackage.class})
public class MockBankSimpleDataTestConfiguration {
    private ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    @Bean
    public ASPSPConfigSource mockBankConfigSource() {
        return new MockBankConfigSource();
    }

    @Bean
    public MockbankInitData init() throws AccountNotFoundMiddlewareException, PaymentProcessingMiddlewareException, UserAlreadyExistsMiddlewareException, AccountWithPrefixGoneMiddlewareException, AccountWithSuffixExistsMiddlewareException, UserNotFoundMiddlewareException, InsufficientPermissionMiddlewareException {
        return this.loadTestData("mockbank-simple-data-test-init-data.yml");
    }

    @Bean
    public DataUploadService mockBankSimpleDataUploadService(Environment env) {
        return new DataUploadServiceImpl(env);
    }

    private MockbankInitData loadTestData(String file) {
        InputStream inputStream = MockBankSimpleDataTestBasePackage.class.getResourceAsStream(file);
        try {
            return (MockbankInitData)this.mapper.readValue(inputStream, MockbankInitData.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

