/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.validation;

import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.impl.service.validation.AbstractPaymentValidator;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.util.Ids;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PaymentIdValidator
extends AbstractPaymentValidator {
    private final DepositAccountPaymentService paymentService;

    @Override
    public void check(PaymentBO payment, UserBO user) {
        this.validateAndUpdate(payment.getPaymentId(), arg_0 -> ((PaymentBO)payment).setPaymentId(arg_0), true);
        payment.getTargets().forEach(t -> this.validateAndUpdate(t.getPaymentId(), arg_0 -> ((PaymentTargetBO)t).setPaymentId(arg_0), false));
        this.checkNext(payment, user);
    }

    private void validateAndUpdate(String id, Consumer<String> idConsumer, boolean isDebtorPart) {
        if (StringUtils.isBlank((CharSequence)id)) {
            id = this.generateId(idConsumer);
        }
        while (this.validateId(id, isDebtorPart)) {
            id = this.generateId(idConsumer);
        }
    }

    private boolean validateId(String id, boolean isDebtorPart) {
        boolean exists;
        boolean bl = exists = isDebtorPart ? this.paymentService.existingPaymentById(id) : this.paymentService.existingTargetById(id);
        if (isDebtorPart && exists) {
            throw MiddlewareModuleException.paymentValidationException((String)"Payment with id: %s already exists!");
        }
        return exists;
    }

    private String generateId(Consumer<String> idConsumer) {
        String generatedId = Ids.id();
        idConsumer.accept(generatedId);
        return generatedId;
    }

    public PaymentIdValidator(DepositAccountPaymentService paymentService) {
        this.paymentService = paymentService;
    }
}

