/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.upload;

import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.impl.service.upload.ExpressionExecutionWrapper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UploadUserService {
    private static final Logger log = LoggerFactory.getLogger(UploadUserService.class);
    private final MiddlewareUserManagementService middlewareUserService;

    public List<UserTO> uploadUsers(List<UserTO> users, String branch) {
        return users.stream().map(u -> u.updateUserBranch(branch)).map(u -> ExpressionExecutionWrapper.execute(() -> {
            List temp = u.getAccountAccesses();
            u.setAccountAccesses(Collections.emptyList());
            try {
                UserTO to = this.middlewareUserService.create(u);
                to.setAccountAccesses(temp);
                return to;
            }
            catch (Exception e) {
                log.info("Seems user already present, skipping creation, {}", (Object)e.getMessage());
                return u;
            }
        })).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public UploadUserService(MiddlewareUserManagementService middlewareUserService) {
        this.middlewareUserService = middlewareUserService;
    }
}

