/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.upload;

import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTargetTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.util.random.RandomUtils;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Currency;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import org.springframework.stereotype.Service;

@Service
public class PaymentGenerationService {
    private static final String TEST_CREDITOR_IBAN = "DE68370400440000000000";
    private static final Random random = new SecureRandom();

    public Map<PaymentTypeTO, PaymentTO> generatePayments(AccountBalanceTO balance, String branch) {
        EnumMap<PaymentTypeTO, PaymentTO> map = new EnumMap<PaymentTypeTO, PaymentTO>(PaymentTypeTO.class);
        map.put(PaymentTypeTO.SINGLE, this.generatePaymentTO(balance, branch, false));
        map.put(PaymentTypeTO.BULK, this.generatePaymentTO(balance, branch, true));
        return map;
    }

    private PaymentTO generatePaymentTO(AccountBalanceTO balance, String branch, boolean isBulk) {
        PaymentTO payment = new PaymentTO();
        payment.setPaymentType(isBulk ? PaymentTypeTO.BULK : PaymentTypeTO.SINGLE);
        payment.setDebtorAccount(this.generateReference(balance.getIban(), balance.getAmount().getCurrency()));
        payment.setTransactionStatus(TransactionStatusTO.RCVD);
        payment.setPaymentProduct("instant-sepa-credit-transfers");
        payment.setRequestedExecutionDate(LocalDate.now());
        ArrayList<PaymentTargetTO> targets = new ArrayList<PaymentTargetTO>();
        targets.add(this.generateTarget(balance, branch));
        if (isBulk) {
            targets.add(this.generateTarget(balance, branch));
        }
        payment.setTargets(targets);
        return payment;
    }

    private PaymentTargetTO generateTarget(AccountBalanceTO balance, String branch) {
        PaymentTargetTO target = new PaymentTargetTO();
        String endToEndId = this.generateEndToEndId(branch);
        target.setEndToEndIdentification(endToEndId);
        target.setInstructedAmount(this.generateAmount(balance));
        target.setCreditorAccount(this.generateReference(TEST_CREDITOR_IBAN, balance.getAmount().getCurrency()));
        target.setCreditorAgent("adorsys GmbH & CO KG");
        target.setCreditorName("adorsys GmbH & CO KG");
        target.setCreditorAddress(this.getTestCreditorAddress());
        return target;
    }

    private AmountTO generateAmount(AccountBalanceTO balance) {
        AmountTO amount = new AmountTO();
        amount.setCurrency(balance.getAmount().getCurrency());
        int balanceAmount = balance.getAmount().getAmount().intValue();
        int maxAmount = balanceAmount * 100 / 3;
        int rand = random.nextInt(maxAmount - 1) + 1;
        amount.setAmount(BigDecimal.valueOf((double)rand / 100.0));
        return amount;
    }

    private AddressTO getTestCreditorAddress() {
        return new AddressTO("F\u00fcrther Str.", "246a", "N\u00fcrnberg", "90429", "Germany", null, null);
    }

    private AccountReferenceTO generateReference(String iban, Currency currency) {
        AccountReferenceTO reference = new AccountReferenceTO();
        reference.setIban(iban);
        reference.setCurrency(currency);
        return reference;
    }

    private String generateEndToEndId(String branchId) {
        return String.join((CharSequence)"_", branchId, String.valueOf(LocalDateTime.now().toEpochSecond(ZoneOffset.UTC)) + random.nextInt(9), String.valueOf(RandomUtils.threadRandomLong((long)10000L, (long)99999L)));
    }
}

