/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.middleware.api.domain.sca.AuthCodeDataTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.impl.converter.AuthCodeDataConverter;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import org.springframework.stereotype.Component;

@Component
public class AuthCodeDataConverterImpl
implements AuthCodeDataConverter {
    @Override
    public AuthCodeDataBO toAuthCodeDataBO(AuthCodeDataTO to) {
        if (to == null) {
            return null;
        }
        AuthCodeDataBO authCodeDataBO = new AuthCodeDataBO();
        authCodeDataBO.setUserLogin(to.getUserLogin());
        authCodeDataBO.setScaUserDataId(to.getScaUserDataId());
        authCodeDataBO.setOpId(to.getOpId());
        authCodeDataBO.setUserMessage(to.getUserMessage());
        authCodeDataBO.setValiditySeconds(to.getValiditySeconds());
        authCodeDataBO.setOpType(this.opTypeTOToOpTypeBO(to.getOpType()));
        authCodeDataBO.setAuthorisationId(to.getAuthorisationId());
        return authCodeDataBO;
    }

    protected OpTypeBO opTypeTOToOpTypeBO(OpTypeTO opTypeTO) {
        OpTypeBO opTypeBO;
        if (opTypeTO == null) {
            return null;
        }
        switch (opTypeTO) {
            case CONSENT: {
                opTypeBO = OpTypeBO.CONSENT;
                break;
            }
            case PAYMENT: {
                opTypeBO = OpTypeBO.PAYMENT;
                break;
            }
            case CANCEL_PAYMENT: {
                opTypeBO = OpTypeBO.CANCEL_PAYMENT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + opTypeTO);
            }
        }
        return opTypeBO;
    }
}

