/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.TokenUsageTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.impl.converter.AccessTokenMapper;
import de.adorsys.ledgers.um.api.domain.AccessTokenBO;
import de.adorsys.ledgers.um.api.domain.AisAccountAccessInfoBO;
import de.adorsys.ledgers.um.api.domain.AisAccountAccessTypeBO;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import de.adorsys.ledgers.um.api.domain.TokenUsageBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class AccessTokenMapperImpl
implements AccessTokenMapper {
    @Override
    public AccessTokenBO toAccessTokenBO(AccessTokenTO token) {
        if (token == null) {
            return null;
        }
        AccessTokenBO accessTokenBO = new AccessTokenBO();
        accessTokenBO.setSub(token.getSub());
        accessTokenBO.setJti(token.getJti());
        accessTokenBO.setLogin(token.getLogin());
        accessTokenBO.setConsent(this.aisConsentTOToAisConsentBO(token.getConsent()));
        accessTokenBO.setRole(this.userRoleTOToUserRoleBO(token.getRole()));
        accessTokenBO.setIat(token.getIat());
        accessTokenBO.setExp(token.getExp());
        Map map = token.getAct();
        if (map != null) {
            accessTokenBO.setAct(new HashMap(map));
        }
        accessTokenBO.setScaId(token.getScaId());
        accessTokenBO.setAuthorisationId(token.getAuthorisationId());
        accessTokenBO.setTokenUsage(this.tokenUsageTOToTokenUsageBO(token.getTokenUsage()));
        return accessTokenBO;
    }

    @Override
    public AccessTokenTO toAccessTokenTO(AccessTokenBO token) {
        if (token == null) {
            return null;
        }
        AccessTokenTO accessTokenTO = new AccessTokenTO();
        accessTokenTO.setSub(token.getSub());
        accessTokenTO.setJti(token.getJti());
        accessTokenTO.setLogin(token.getLogin());
        accessTokenTO.setConsent(this.aisConsentBOToAisConsentTO(token.getConsent()));
        accessTokenTO.setRole(this.userRoleBOToUserRoleTO(token.getRole()));
        accessTokenTO.setIat(token.getIat());
        accessTokenTO.setExp(token.getExp());
        Map map = token.getAct();
        if (map != null) {
            accessTokenTO.setAct(new HashMap(map));
        }
        accessTokenTO.setScaId(token.getScaId());
        accessTokenTO.setAuthorisationId(token.getAuthorisationId());
        accessTokenTO.setTokenUsage(this.tokenUsageBOToTokenUsageTO(token.getTokenUsage()));
        return accessTokenTO;
    }

    protected AisAccountAccessTypeBO aisAccountAccessTypeTOToAisAccountAccessTypeBO(AisAccountAccessTypeTO aisAccountAccessTypeTO) {
        AisAccountAccessTypeBO aisAccountAccessTypeBO;
        if (aisAccountAccessTypeTO == null) {
            return null;
        }
        switch (aisAccountAccessTypeTO) {
            case ALL_ACCOUNTS: {
                aisAccountAccessTypeBO = AisAccountAccessTypeBO.ALL_ACCOUNTS;
                break;
            }
            case ALL_ACCOUNTS_WITH_BALANCES: {
                aisAccountAccessTypeBO = AisAccountAccessTypeBO.ALL_ACCOUNTS_WITH_BALANCES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + aisAccountAccessTypeTO);
            }
        }
        return aisAccountAccessTypeBO;
    }

    protected AisAccountAccessInfoBO aisAccountAccessInfoTOToAisAccountAccessInfoBO(AisAccountAccessInfoTO aisAccountAccessInfoTO) {
        List list2;
        List list1;
        if (aisAccountAccessInfoTO == null) {
            return null;
        }
        AisAccountAccessInfoBO aisAccountAccessInfoBO = new AisAccountAccessInfoBO();
        List list = aisAccountAccessInfoTO.getAccounts();
        if (list != null) {
            aisAccountAccessInfoBO.setAccounts(new ArrayList(list));
        }
        if ((list1 = aisAccountAccessInfoTO.getBalances()) != null) {
            aisAccountAccessInfoBO.setBalances(new ArrayList(list1));
        }
        if ((list2 = aisAccountAccessInfoTO.getTransactions()) != null) {
            aisAccountAccessInfoBO.setTransactions(new ArrayList(list2));
        }
        aisAccountAccessInfoBO.setAvailableAccounts(this.aisAccountAccessTypeTOToAisAccountAccessTypeBO(aisAccountAccessInfoTO.getAvailableAccounts()));
        aisAccountAccessInfoBO.setAllPsd2(this.aisAccountAccessTypeTOToAisAccountAccessTypeBO(aisAccountAccessInfoTO.getAllPsd2()));
        return aisAccountAccessInfoBO;
    }

    protected AisConsentBO aisConsentTOToAisConsentBO(AisConsentTO aisConsentTO) {
        if (aisConsentTO == null) {
            return null;
        }
        AisConsentBO aisConsentBO = new AisConsentBO();
        aisConsentBO.setId(aisConsentTO.getId());
        aisConsentBO.setUserId(aisConsentTO.getUserId());
        aisConsentBO.setTppId(aisConsentTO.getTppId());
        aisConsentBO.setFrequencyPerDay(aisConsentTO.getFrequencyPerDay());
        aisConsentBO.setAccess(this.aisAccountAccessInfoTOToAisAccountAccessInfoBO(aisConsentTO.getAccess()));
        aisConsentBO.setValidUntil(aisConsentTO.getValidUntil());
        aisConsentBO.setRecurringIndicator(aisConsentTO.isRecurringIndicator());
        return aisConsentBO;
    }

    protected UserRoleBO userRoleTOToUserRoleBO(UserRoleTO userRoleTO) {
        UserRoleBO userRoleBO;
        if (userRoleTO == null) {
            return null;
        }
        switch (userRoleTO) {
            case CUSTOMER: {
                userRoleBO = UserRoleBO.CUSTOMER;
                break;
            }
            case STAFF: {
                userRoleBO = UserRoleBO.STAFF;
                break;
            }
            case TECHNICAL: {
                userRoleBO = UserRoleBO.TECHNICAL;
                break;
            }
            case SYSTEM: {
                userRoleBO = UserRoleBO.SYSTEM;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + userRoleTO);
            }
        }
        return userRoleBO;
    }

    protected TokenUsageBO tokenUsageTOToTokenUsageBO(TokenUsageTO tokenUsageTO) {
        TokenUsageBO tokenUsageBO;
        if (tokenUsageTO == null) {
            return null;
        }
        switch (tokenUsageTO) {
            case LOGIN: {
                tokenUsageBO = TokenUsageBO.LOGIN;
                break;
            }
            case DIRECT_ACCESS: {
                tokenUsageBO = TokenUsageBO.DIRECT_ACCESS;
                break;
            }
            case DELEGATED_ACCESS: {
                tokenUsageBO = TokenUsageBO.DELEGATED_ACCESS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + tokenUsageTO);
            }
        }
        return tokenUsageBO;
    }

    protected AisAccountAccessTypeTO aisAccountAccessTypeBOToAisAccountAccessTypeTO(AisAccountAccessTypeBO aisAccountAccessTypeBO) {
        AisAccountAccessTypeTO aisAccountAccessTypeTO;
        if (aisAccountAccessTypeBO == null) {
            return null;
        }
        switch (aisAccountAccessTypeBO) {
            case ALL_ACCOUNTS: {
                aisAccountAccessTypeTO = AisAccountAccessTypeTO.ALL_ACCOUNTS;
                break;
            }
            case ALL_ACCOUNTS_WITH_BALANCES: {
                aisAccountAccessTypeTO = AisAccountAccessTypeTO.ALL_ACCOUNTS_WITH_BALANCES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + aisAccountAccessTypeBO);
            }
        }
        return aisAccountAccessTypeTO;
    }

    protected AisAccountAccessInfoTO aisAccountAccessInfoBOToAisAccountAccessInfoTO(AisAccountAccessInfoBO aisAccountAccessInfoBO) {
        List list2;
        List list1;
        if (aisAccountAccessInfoBO == null) {
            return null;
        }
        AisAccountAccessInfoTO aisAccountAccessInfoTO = new AisAccountAccessInfoTO();
        List list = aisAccountAccessInfoBO.getAccounts();
        if (list != null) {
            aisAccountAccessInfoTO.setAccounts(new ArrayList(list));
        }
        if ((list1 = aisAccountAccessInfoBO.getBalances()) != null) {
            aisAccountAccessInfoTO.setBalances(new ArrayList(list1));
        }
        if ((list2 = aisAccountAccessInfoBO.getTransactions()) != null) {
            aisAccountAccessInfoTO.setTransactions(new ArrayList(list2));
        }
        aisAccountAccessInfoTO.setAvailableAccounts(this.aisAccountAccessTypeBOToAisAccountAccessTypeTO(aisAccountAccessInfoBO.getAvailableAccounts()));
        aisAccountAccessInfoTO.setAllPsd2(this.aisAccountAccessTypeBOToAisAccountAccessTypeTO(aisAccountAccessInfoBO.getAllPsd2()));
        return aisAccountAccessInfoTO;
    }

    protected AisConsentTO aisConsentBOToAisConsentTO(AisConsentBO aisConsentBO) {
        if (aisConsentBO == null) {
            return null;
        }
        AisConsentTO aisConsentTO = new AisConsentTO();
        aisConsentTO.setId(aisConsentBO.getId());
        aisConsentTO.setUserId(aisConsentBO.getUserId());
        aisConsentTO.setTppId(aisConsentBO.getTppId());
        aisConsentTO.setFrequencyPerDay(aisConsentBO.getFrequencyPerDay());
        aisConsentTO.setAccess(this.aisAccountAccessInfoBOToAisAccountAccessInfoTO(aisConsentBO.getAccess()));
        aisConsentTO.setValidUntil(aisConsentBO.getValidUntil());
        aisConsentTO.setRecurringIndicator(aisConsentBO.isRecurringIndicator());
        return aisConsentTO;
    }

    protected UserRoleTO userRoleBOToUserRoleTO(UserRoleBO userRoleBO) {
        UserRoleTO userRoleTO;
        if (userRoleBO == null) {
            return null;
        }
        switch (userRoleBO) {
            case CUSTOMER: {
                userRoleTO = UserRoleTO.CUSTOMER;
                break;
            }
            case STAFF: {
                userRoleTO = UserRoleTO.STAFF;
                break;
            }
            case TECHNICAL: {
                userRoleTO = UserRoleTO.TECHNICAL;
                break;
            }
            case SYSTEM: {
                userRoleTO = UserRoleTO.SYSTEM;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + userRoleBO);
            }
        }
        return userRoleTO;
    }

    protected TokenUsageTO tokenUsageBOToTokenUsageTO(TokenUsageBO tokenUsageBO) {
        TokenUsageTO tokenUsageTO;
        if (tokenUsageBO == null) {
            return null;
        }
        switch (tokenUsageBO) {
            case LOGIN: {
                tokenUsageTO = TokenUsageTO.LOGIN;
                break;
            }
            case DIRECT_ACCESS: {
                tokenUsageTO = TokenUsageTO.DIRECT_ACCESS;
                break;
            }
            case DELEGATED_ACCESS: {
                tokenUsageTO = TokenUsageTO.DELEGATED_ACCESS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + tokenUsageBO);
            }
        }
        return tokenUsageTO;
    }
}

