package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaMethodTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.um.api.domain.AccessTypeBO;
import de.adorsys.ledgers.um.api.domain.AccountAccessBO;
import de.adorsys.ledgers.um.api.domain.ScaMethodTypeBO;
import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.domain.UserExtendedBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-02-12T12:51:39+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.10 (Azul Systems, Inc.)"
)
@Component
public class UserMapperImpl implements UserMapper {

    @Override
    public UserTO toUserTO(UserBO user) {
        if ( user == null ) {
            return null;
        }

        UserTO userTO = new UserTO();

        userTO.setId( user.getId() );
        userTO.setLogin( user.getLogin() );
        userTO.setEmail( user.getEmail() );
        userTO.setPin( user.getPin() );
        userTO.setScaUserData( toScaUserDataListTO( user.getScaUserData() ) );
        userTO.setAccountAccesses( accountAccessBOListToAccountAccessTOList( user.getAccountAccesses() ) );
        userTO.setUserRoles( userRoleBOCollectionToUserRoleTOCollection( user.getUserRoles() ) );
        userTO.setBranch( user.getBranch() );
        userTO.setBlocked( user.isBlocked() );
        userTO.setSystemBlocked( user.isSystemBlocked() );

        return userTO;
    }

    @Override
    public UserExtendedTO toUserExtendedTO(UserExtendedBO user) {
        if ( user == null ) {
            return null;
        }

        UserExtendedTO userExtendedTO = new UserExtendedTO();

        userExtendedTO.setId( user.getId() );
        userExtendedTO.setLogin( user.getLogin() );
        userExtendedTO.setEmail( user.getEmail() );
        userExtendedTO.setPin( user.getPin() );
        userExtendedTO.setScaUserData( toScaUserDataListTO( user.getScaUserData() ) );
        userExtendedTO.setAccountAccesses( accountAccessBOListToAccountAccessTOList( user.getAccountAccesses() ) );
        userExtendedTO.setUserRoles( userRoleBOCollectionToUserRoleTOCollection( user.getUserRoles() ) );
        userExtendedTO.setBranch( user.getBranch() );
        userExtendedTO.setBlocked( user.isBlocked() );
        userExtendedTO.setSystemBlocked( user.isSystemBlocked() );
        userExtendedTO.setBranchLogin( user.getBranchLogin() );

        return userExtendedTO;
    }

    @Override
    public UserBO toUserBO(UserTO user) {
        if ( user == null ) {
            return null;
        }

        UserBO userBO = new UserBO();

        userBO.setId( user.getId() );
        userBO.setLogin( user.getLogin() );
        userBO.setEmail( user.getEmail() );
        userBO.setPin( user.getPin() );
        userBO.setScaUserData( toScaUserDataListBO( user.getScaUserData() ) );
        userBO.setAccountAccesses( accountAccessTOListToAccountAccessBOList( user.getAccountAccesses() ) );
        userBO.setUserRoles( userRoleTOCollectionToUserRoleBOCollection( user.getUserRoles() ) );
        userBO.setBranch( user.getBranch() );
        userBO.setBlocked( user.isBlocked() );
        userBO.setSystemBlocked( user.isSystemBlocked() );

        return userBO;
    }

    @Override
    public List<UserTO> toUserTOList(List<UserBO> listUsers) {
        if ( listUsers == null ) {
            return null;
        }

        List<UserTO> list = new ArrayList<UserTO>( listUsers.size() );
        for ( UserBO userBO : listUsers ) {
            list.add( toUserTO( userBO ) );
        }

        return list;
    }

    @Override
    public ScaUserDataTO toScaUserDataTO(ScaUserDataBO bo) {
        if ( bo == null ) {
            return null;
        }

        ScaUserDataTO scaUserDataTO = new ScaUserDataTO();

        scaUserDataTO.setId( bo.getId() );
        scaUserDataTO.setScaMethod( scaMethodTypeBOToScaMethodTypeTO( bo.getScaMethod() ) );
        scaUserDataTO.setMethodValue( bo.getMethodValue() );
        scaUserDataTO.setUsesStaticTan( bo.isUsesStaticTan() );
        scaUserDataTO.setStaticTan( bo.getStaticTan() );
        scaUserDataTO.setValid( bo.isValid() );

        return scaUserDataTO;
    }

    @Override
    public List<ScaUserDataBO> toScaUserDataListBO(List<ScaUserDataTO> list) {
        if ( list == null ) {
            return null;
        }

        List<ScaUserDataBO> list1 = new ArrayList<ScaUserDataBO>( list.size() );
        for ( ScaUserDataTO scaUserDataTO : list ) {
            list1.add( scaUserDataTOToScaUserDataBO( scaUserDataTO ) );
        }

        return list1;
    }

    @Override
    public List<ScaUserDataTO> toScaUserDataListTO(List<ScaUserDataBO> bos) {
        if ( bos == null ) {
            return null;
        }

        List<ScaUserDataTO> list = new ArrayList<ScaUserDataTO>( bos.size() );
        for ( ScaUserDataBO scaUserDataBO : bos ) {
            list.add( toScaUserDataTO( scaUserDataBO ) );
        }

        return list;
    }

    @Override
    public List<UserRoleBO> toUserRoleBO(List<UserRoleTO> userRoles) {
        if ( userRoles == null ) {
            return null;
        }

        List<UserRoleBO> list = new ArrayList<UserRoleBO>( userRoles.size() );
        for ( UserRoleTO userRoleTO : userRoles ) {
            list.add( userRoleTOToUserRoleBO( userRoleTO ) );
        }

        return list;
    }

    @Override
    public AccountAccessBO toAccountAccessFromReference(AccountReferenceTO source) {
        if ( source == null ) {
            return null;
        }

        AccountAccessBO accountAccessBO = new AccountAccessBO();

        accountAccessBO.setIban( source.getIban() );
        accountAccessBO.setCurrency( source.getCurrency() );

        return accountAccessBO;
    }

    @Override
    public List<AccountAccessBO> toAccountAccessFromReferenceList(List<AccountReferenceTO> source) {
        if ( source == null ) {
            return null;
        }

        List<AccountAccessBO> list = new ArrayList<AccountAccessBO>( source.size() );
        for ( AccountReferenceTO accountReferenceTO : source ) {
            list.add( toAccountAccessFromReference( accountReferenceTO ) );
        }

        return list;
    }

    protected AccessTypeTO accessTypeBOToAccessTypeTO(AccessTypeBO accessTypeBO) {
        if ( accessTypeBO == null ) {
            return null;
        }

        AccessTypeTO accessTypeTO;

        switch ( accessTypeBO ) {
            case OWNER: accessTypeTO = AccessTypeTO.OWNER;
            break;
            case READ: accessTypeTO = AccessTypeTO.READ;
            break;
            case DISPOSE: accessTypeTO = AccessTypeTO.DISPOSE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accessTypeBO );
        }

        return accessTypeTO;
    }

    protected AccountAccessTO accountAccessBOToAccountAccessTO(AccountAccessBO accountAccessBO) {
        if ( accountAccessBO == null ) {
            return null;
        }

        AccountAccessTO accountAccessTO = new AccountAccessTO();

        accountAccessTO.setId( accountAccessBO.getId() );
        accountAccessTO.setIban( accountAccessBO.getIban() );
        accountAccessTO.setCurrency( accountAccessBO.getCurrency() );
        accountAccessTO.setAccessType( accessTypeBOToAccessTypeTO( accountAccessBO.getAccessType() ) );
        accountAccessTO.setScaWeight( accountAccessBO.getScaWeight() );
        accountAccessTO.setAccountId( accountAccessBO.getAccountId() );

        return accountAccessTO;
    }

    protected List<AccountAccessTO> accountAccessBOListToAccountAccessTOList(List<AccountAccessBO> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountAccessTO> list1 = new ArrayList<AccountAccessTO>( list.size() );
        for ( AccountAccessBO accountAccessBO : list ) {
            list1.add( accountAccessBOToAccountAccessTO( accountAccessBO ) );
        }

        return list1;
    }

    protected UserRoleTO userRoleBOToUserRoleTO(UserRoleBO userRoleBO) {
        if ( userRoleBO == null ) {
            return null;
        }

        UserRoleTO userRoleTO;

        switch ( userRoleBO ) {
            case CUSTOMER: userRoleTO = UserRoleTO.CUSTOMER;
            break;
            case STAFF: userRoleTO = UserRoleTO.STAFF;
            break;
            case TECHNICAL: userRoleTO = UserRoleTO.TECHNICAL;
            break;
            case SYSTEM: userRoleTO = UserRoleTO.SYSTEM;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + userRoleBO );
        }

        return userRoleTO;
    }

    protected Collection<UserRoleTO> userRoleBOCollectionToUserRoleTOCollection(Collection<UserRoleBO> collection) {
        if ( collection == null ) {
            return null;
        }

        Collection<UserRoleTO> collection1 = new ArrayList<UserRoleTO>( collection.size() );
        for ( UserRoleBO userRoleBO : collection ) {
            collection1.add( userRoleBOToUserRoleTO( userRoleBO ) );
        }

        return collection1;
    }

    protected AccessTypeBO accessTypeTOToAccessTypeBO(AccessTypeTO accessTypeTO) {
        if ( accessTypeTO == null ) {
            return null;
        }

        AccessTypeBO accessTypeBO;

        switch ( accessTypeTO ) {
            case OWNER: accessTypeBO = AccessTypeBO.OWNER;
            break;
            case READ: accessTypeBO = AccessTypeBO.READ;
            break;
            case DISPOSE: accessTypeBO = AccessTypeBO.DISPOSE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accessTypeTO );
        }

        return accessTypeBO;
    }

    protected AccountAccessBO accountAccessTOToAccountAccessBO(AccountAccessTO accountAccessTO) {
        if ( accountAccessTO == null ) {
            return null;
        }

        AccountAccessBO accountAccessBO = new AccountAccessBO();

        accountAccessBO.setId( accountAccessTO.getId() );
        accountAccessBO.setIban( accountAccessTO.getIban() );
        accountAccessBO.setCurrency( accountAccessTO.getCurrency() );
        accountAccessBO.setAccessType( accessTypeTOToAccessTypeBO( accountAccessTO.getAccessType() ) );
        accountAccessBO.setScaWeight( accountAccessTO.getScaWeight() );
        accountAccessBO.setAccountId( accountAccessTO.getAccountId() );

        return accountAccessBO;
    }

    protected List<AccountAccessBO> accountAccessTOListToAccountAccessBOList(List<AccountAccessTO> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountAccessBO> list1 = new ArrayList<AccountAccessBO>( list.size() );
        for ( AccountAccessTO accountAccessTO : list ) {
            list1.add( accountAccessTOToAccountAccessBO( accountAccessTO ) );
        }

        return list1;
    }

    protected UserRoleBO userRoleTOToUserRoleBO(UserRoleTO userRoleTO) {
        if ( userRoleTO == null ) {
            return null;
        }

        UserRoleBO userRoleBO;

        switch ( userRoleTO ) {
            case CUSTOMER: userRoleBO = UserRoleBO.CUSTOMER;
            break;
            case STAFF: userRoleBO = UserRoleBO.STAFF;
            break;
            case TECHNICAL: userRoleBO = UserRoleBO.TECHNICAL;
            break;
            case SYSTEM: userRoleBO = UserRoleBO.SYSTEM;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + userRoleTO );
        }

        return userRoleBO;
    }

    protected Collection<UserRoleBO> userRoleTOCollectionToUserRoleBOCollection(Collection<UserRoleTO> collection) {
        if ( collection == null ) {
            return null;
        }

        Collection<UserRoleBO> collection1 = new ArrayList<UserRoleBO>( collection.size() );
        for ( UserRoleTO userRoleTO : collection ) {
            collection1.add( userRoleTOToUserRoleBO( userRoleTO ) );
        }

        return collection1;
    }

    protected ScaMethodTypeTO scaMethodTypeBOToScaMethodTypeTO(ScaMethodTypeBO scaMethodTypeBO) {
        if ( scaMethodTypeBO == null ) {
            return null;
        }

        ScaMethodTypeTO scaMethodTypeTO;

        switch ( scaMethodTypeBO ) {
            case EMAIL: scaMethodTypeTO = ScaMethodTypeTO.EMAIL;
            break;
            case MOBILE: scaMethodTypeTO = ScaMethodTypeTO.MOBILE;
            break;
            case CHIP_OTP: scaMethodTypeTO = ScaMethodTypeTO.CHIP_OTP;
            break;
            case PHOTO_OTP: scaMethodTypeTO = ScaMethodTypeTO.PHOTO_OTP;
            break;
            case PUSH_OTP: scaMethodTypeTO = ScaMethodTypeTO.PUSH_OTP;
            break;
            case SMS_OTP: scaMethodTypeTO = ScaMethodTypeTO.SMS_OTP;
            break;
            case APP_OTP: scaMethodTypeTO = ScaMethodTypeTO.APP_OTP;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + scaMethodTypeBO );
        }

        return scaMethodTypeTO;
    }

    protected ScaMethodTypeBO scaMethodTypeTOToScaMethodTypeBO(ScaMethodTypeTO scaMethodTypeTO) {
        if ( scaMethodTypeTO == null ) {
            return null;
        }

        ScaMethodTypeBO scaMethodTypeBO;

        switch ( scaMethodTypeTO ) {
            case EMAIL: scaMethodTypeBO = ScaMethodTypeBO.EMAIL;
            break;
            case MOBILE: scaMethodTypeBO = ScaMethodTypeBO.MOBILE;
            break;
            case CHIP_OTP: scaMethodTypeBO = ScaMethodTypeBO.CHIP_OTP;
            break;
            case PHOTO_OTP: scaMethodTypeBO = ScaMethodTypeBO.PHOTO_OTP;
            break;
            case PUSH_OTP: scaMethodTypeBO = ScaMethodTypeBO.PUSH_OTP;
            break;
            case SMS_OTP: scaMethodTypeBO = ScaMethodTypeBO.SMS_OTP;
            break;
            case APP_OTP: scaMethodTypeBO = ScaMethodTypeBO.APP_OTP;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + scaMethodTypeTO );
        }

        return scaMethodTypeBO;
    }

    protected ScaUserDataBO scaUserDataTOToScaUserDataBO(ScaUserDataTO scaUserDataTO) {
        if ( scaUserDataTO == null ) {
            return null;
        }

        ScaUserDataBO scaUserDataBO = new ScaUserDataBO();

        scaUserDataBO.setId( scaUserDataTO.getId() );
        scaUserDataBO.setScaMethod( scaMethodTypeTOToScaMethodTypeBO( scaUserDataTO.getScaMethod() ) );
        scaUserDataBO.setMethodValue( scaUserDataTO.getMethodValue() );
        scaUserDataBO.setUsesStaticTan( scaUserDataTO.isUsesStaticTan() );
        scaUserDataBO.setStaticTan( scaUserDataTO.getStaticTan() );
        scaUserDataBO.setValid( scaUserDataTO.isValid() );

        return scaUserDataBO;
    }
}
