/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.validation;

import de.adorsys.ledgers.deposit.api.domain.AddressBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.impl.config.PaymentProductsConfig;
import de.adorsys.ledgers.middleware.impl.service.validation.AbstractPaymentValidator;
import de.adorsys.ledgers.middleware.impl.service.validation.PaymentFieldValidator;
import de.adorsys.ledgers.um.api.domain.UserBO;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PaymentSyntacticalValidator
extends AbstractPaymentValidator {
    private static final Logger log = LoggerFactory.getLogger(PaymentSyntacticalValidator.class);
    private final PaymentProductsConfig paymentProductsConfig;
    @Value(value="${ledgers.payment_validator.allow_past_dates:true}")
    private boolean allowDatesInThePast;
    @Value(value="${ledgers.payment_validator.allow_same_end_to_end_ids:true}")
    private boolean allowSameEndToEndIds;

    @Override
    public void check(PaymentBO payment, UserBO user) {
        this.checkDebtorPart(payment);
        this.checkCreditorParts(payment);
        this.checkPaymentTypeRelatedFields(payment);
        this.checkNext(payment, user);
    }

    private void checkDebtorPart(PaymentBO payment) {
        this.errorIf(payment.getPaymentType() == null, "PaymentType is required!");
        this.shouldBePresent(() -> ((PaymentBO)payment).getPaymentProduct(), "PaymentProduct");
        this.errorIf(this.paymentProductsConfig.isNotSupportedPaymentProduct(payment.getPaymentProduct()), "Payment Product not Supported!");
        this.errorIf(PaymentFieldValidator.isInvalidStartingTransactionStatus(payment), "Invalid transactionStatus for initiation!");
        this.errorIf(payment.getDebtorAccount() == null, "DebtorAccount should be present!");
        this.errorIf(payment.getDebtorAccount().isInvalidReference(), "Malformed debtorAccount!");
        this.errorIf(!PaymentFieldValidator.isValidAmount(payment), "Amount can not be negative!");
        payment.getTargets().forEach(t -> this.shouldBePresent(() -> ((PaymentTargetBO)t).getEndToEndIdentification(), "EndToEndIdentification"));
        this.errorIf(PaymentFieldValidator.isInvalidEndToEndIds(payment, this.allowSameEndToEndIds), "EndToEndIdentification's should be unique!");
    }

    private void checkCreditorParts(PaymentBO payment) {
        this.errorIf(CollectionUtils.isEmpty((Collection)payment.getTargets()), "Payment targets are absent!");
        payment.getTargets().forEach(this::validateTarget);
    }

    private void checkPaymentTypeRelatedFields(PaymentBO payment) {
        this.errorIf(BooleanUtils.isTrue((Boolean)payment.getBatchBookingPreferred()) && PaymentTypeBO.BULK != payment.getPaymentType(), "BatchBooking is only valid for Bulk payments!");
        if (PaymentTypeBO.PERIODIC == payment.getPaymentType()) {
            this.shouldBeNull(() -> ((PaymentBO)payment).getRequestedExecutionDate(), "requestedExecutionDate");
            this.shouldBeNull(() -> ((PaymentBO)payment).getRequestedExecutionTime(), "requestedExecutionTime");
            this.errorIf(PaymentFieldValidator.isInvalidStartDate(payment, this.allowDatesInThePast), "Invalid startDate!");
            this.errorIf(PaymentFieldValidator.isInvalidEndDate(payment), "Invalid endDate! End date should be after startDate!");
            this.errorIf(PaymentFieldValidator.isInvalidExecutionRule(payment), "Invalid executionRule!");
            this.errorIf(payment.getFrequency() == null, "FrequencyCode is mandated for Periodic Payments!");
            this.errorIf(PaymentFieldValidator.isInvalidExecutionDay(payment), "Incorrect dayOfExecution!");
        } else {
            this.errorIf(PaymentFieldValidator.isInvalidRequestedExecutionDateTime(payment, this.allowDatesInThePast), "requestedExecutionDate/Time can not be in the past!");
            this.shouldBeNull(() -> ((PaymentBO)payment).getStartDate(), "startDate");
            this.shouldBeNull(() -> ((PaymentBO)payment).getEndDate(), "endDate");
            this.shouldBeNull(() -> ((PaymentBO)payment).getExecutionRule(), "executionRule");
            this.shouldBeNull(() -> ((PaymentBO)payment).getFrequency(), "frequency");
            this.shouldBeNull(() -> ((PaymentBO)payment).getDayOfExecution(), "dayOfExecution");
        }
    }

    private void validateTarget(PaymentTargetBO target) {
        this.shouldBePresent(() -> ((PaymentTargetBO)target).getCreditorName(), "CreditorName");
        this.shouldNotExceed(() -> ((PaymentTargetBO)target).getCreditorName(), 70, "CreditorName");
        this.errorIf(target.getCreditorAccount().isInvalidReference(), "Malformed creditorAccount for " + target.getEndToEndIdentification());
        if (Objects.nonNull(target.getCreditorAddress())) {
            this.validateAddress(target.getCreditorAddress());
        }
        this.shouldNotExceed(() -> ((PaymentTargetBO)target).getRemittanceInformationUnstructured(), 140, "RemittanceInformationUnstructured");
    }

    private void validateAddress(AddressBO address) {
        this.errorIf(address == null, "CreditorAddress is a required field!");
        this.shouldNotExceed(() -> ((AddressBO)address).getStreet(), 70, "Street");
        this.shouldBePresent(() -> ((AddressBO)address).getCountry(), "Country");
    }

    private void shouldBeNull(Supplier<Object> supplier, String fieldName) {
        this.errorIf(supplier.get() != null, fieldName + " is forbidden for current payment type!");
    }

    private void shouldBePresent(Supplier<String> source, String fieldName) {
        this.errorIf(StringUtils.isBlank((CharSequence)source.get()), fieldName + " is Required!");
    }

    private void shouldNotExceed(Supplier<String> source, int maxLength, String fieldName) {
        this.errorIf(StringUtils.isNotBlank((CharSequence)source.get()) && source.get().length() > maxLength, fieldName + " exceeds maximum length!");
    }

    private void errorIf(boolean predicateInvalid, String msg) {
        if (predicateInvalid) {
            log.error(msg);
            throw MiddlewareModuleException.paymentValidationException((String)msg);
        }
    }

    public PaymentSyntacticalValidator(PaymentProductsConfig paymentProductsConfig) {
        this.paymentProductsConfig = paymentProductsConfig;
    }
}

