/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.validation;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.impl.service.validation.AbstractPaymentValidator;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.util.exception.DepositModuleException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Currency;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentAccountValidator
extends AbstractPaymentValidator {
    private static final Logger log = LoggerFactory.getLogger(PaymentAccountValidator.class);
    private final DepositAccountService accountService;

    @Override
    public void check(PaymentBO payment, UserBO user) {
        this.validateAccountsAndFillMissing(payment);
        this.fillDebtorNameIfMissing(user, payment);
        this.checkNext(payment, user);
    }

    private void validateAccountsAndFillMissing(PaymentBO payment) {
        DepositAccountBO account = this.getCheckedAccount(payment);
        payment.updateDebtorAccountCurrency(account.getCurrency());
        payment.setAccountId(account.getId());
    }

    private void fillDebtorNameIfMissing(UserBO user, PaymentBO payment) {
        if (StringUtils.isBlank((CharSequence)payment.getDebtorName())) {
            payment.setDebtorName(user.getLogin());
        }
    }

    private DepositAccountBO getCheckedAccount(PaymentBO paymentBO) {
        paymentBO.getTargets().forEach(t -> {
            try {
                DepositAccountBO acc = this.checkAccountStatusAndCurrencyMatch(t.getCreditorAccount(), false, t.getInstructedAmount().getCurrency());
                t.setCreditorAccount(acc.getReference());
            }
            catch (MiddlewareModuleException e) {
                if (EnumSet.of(MiddlewareErrorCode.ACCOUNT_DISABLED, MiddlewareErrorCode.CURRENCY_MISMATCH).contains(e.getErrorCode())) {
                    log.error(e.getDevMsg());
                    throw e;
                }
            }
            catch (DepositModuleException e) {
                log.info("Creditor account is located in another ASPSP");
            }
        });
        return this.checkAccountStatusAndCurrencyMatch(paymentBO.getDebtorAccount(), true, null);
    }

    private DepositAccountBO checkAccountStatusAndCurrencyMatch(AccountReferenceBO reference, boolean isDebtor, Currency currency) {
        DepositAccountBO account = Optional.ofNullable(reference.getCurrency()).map(c -> this.accountService.getAccountByIbanAndCurrency(reference.getIban(), c)).orElseGet(() -> this.getAccountByIbanAndParamCurrencyErrorIfNotSingle(reference.getIban(), isDebtor, currency));
        if (!account.isEnabled()) {
            throw (MiddlewareModuleException)((Object)MiddlewareModuleException.blockedSupplier((MiddlewareErrorCode)MiddlewareErrorCode.ACCOUNT_DISABLED, (String)reference.getIban(), (boolean)account.isBlocked()).get());
        }
        return account;
    }

    private DepositAccountBO getAccountByIbanAndParamCurrencyErrorIfNotSingle(String iban, boolean isDebtor, Currency currency) {
        List accounts = this.accountService.getAccountsByIbanAndParamCurrency(iban, "");
        if (CollectionUtils.isEmpty((Collection)accounts) && !isDebtor) {
            return DepositAccountBO.builder().iban(iban).currency(currency).creditLimit(BigDecimal.ZERO).build();
        }
        if (accounts.size() != 1) {
            String msg = CollectionUtils.isEmpty((Collection)accounts) ? String.format("Account with IBAN: %s Not Found!", iban) : String.format("Initiation of payment for Account with IBAN: %s is impossible as it is a Multi-Currency-Account. %nPlease specify currency for sub-account to proceed.", iban);
            MiddlewareErrorCode errorCode = CollectionUtils.isEmpty((Collection)accounts) ? MiddlewareErrorCode.PAYMENT_VALIDATION_EXCEPTION : MiddlewareErrorCode.CURRENCY_MISMATCH;
            throw MiddlewareModuleException.builder().errorCode(errorCode).devMsg(msg).build();
        }
        return (DepositAccountBO)accounts.iterator().next();
    }

    public PaymentAccountValidator(DepositAccountService accountService) {
        this.accountService = accountService;
    }
}

