/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.message.step;

import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;

public class PaymentMessageHelper {
    private static final String TAN_MESSAGE_TEMPLATE = "The TAN for your %s %s order # %s is: ";
    private static final String EXEMPTED_MESSAGE_TEMPLATE = "Your %s %s order # %s is scheduled";
    private final String paymentId;
    private final OpTypeBO opType;
    private final PaymentTypeBO paymentType;

    public String getTanTemplate() {
        return this.getTemplate(false);
    }

    public String getExemptedTemplate() {
        return this.getTemplate(true);
    }

    public String resolveMessage(boolean isScaRequired) {
        return isScaRequired ? this.getTanTemplate() : this.getExemptedTemplate();
    }

    private String getTemplate(boolean isExempted) {
        String paymentTyp = OpTypeBO.CANCEL_PAYMENT == this.opType ? "" : this.paymentType.name();
        String operationType = OpTypeBO.CANCEL_PAYMENT == this.opType ? "Payment Cancellation" : "Payment";
        return isExempted ? String.format(EXEMPTED_MESSAGE_TEMPLATE, paymentTyp, operationType, this.paymentId) : String.format(TAN_MESSAGE_TEMPLATE, paymentTyp, operationType, this.paymentId) + "%s";
    }

    public PaymentMessageHelper(String paymentId, OpTypeBO opType, PaymentTypeBO paymentType) {
        this.paymentId = paymentId;
        this.opType = opType;
        this.paymentType = paymentType;
    }
}

