/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.message.step;

import de.adorsys.ledgers.um.api.domain.AisAccountAccessInfoBO;
import de.adorsys.ledgers.um.api.domain.AisAccountAccessTypeBO;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ConsentMessageHelper {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd LLLL yyyy");
    private final AisConsentBO consent;

    public String template() {
        this.checkNullConsent();
        AisAccountAccessInfoBO access = this.consent.getAccess();
        if (access == null) {
            return String.format("No account access to tpp with id: %s", this.consent.getTppId());
        }
        return this.prepareTemplate(access).toString();
    }

    public String exemptedTemplate() {
        this.checkNullConsent();
        AisAccountAccessInfoBO access = this.consent.getAccess();
        if (access == null) {
            return String.format("No account access to tpp with id: %s", this.consent.getTppId());
        }
        return this.template() + "This access has been granted. No TAN entry needed.";
    }

    private StringBuilder prepareTemplate(AisAccountAccessInfoBO access) {
        StringBuilder builder = new StringBuilder(String.format("Account access for TPP with id %s:%n", this.consent.getTppId()));
        if (this.consent.getFrequencyPerDay() <= 1) {
            if (this.consent.isRecurringIndicator()) {
                builder.append("- Up to 1 access per day.\n");
            } else {
                builder.append("- For one time access.\n");
            }
        } else {
            builder.append(String.format("- Up to %s accesses per day.%n", this.consent.getFrequencyPerDay()));
        }
        if (this.consent.getValidUntil() != null) {
            builder.append(String.format("- Access valid until %s.%n", formatter.format(this.consent.getValidUntil())));
        }
        builder.append("Access to following accounts:\n");
        if (AisAccountAccessTypeBO.ALL_ACCOUNTS.equals((Object)access.getAllPsd2())) {
            builder.append("All payments accounts without balances.\n");
        } else if (AisAccountAccessTypeBO.ALL_ACCOUNTS_WITH_BALANCES.equals((Object)access.getAllPsd2())) {
            builder.append("All payments accounts with balances and transactions.\n");
        }
        if (AisAccountAccessTypeBO.ALL_ACCOUNTS.equals((Object)access.getAvailableAccounts())) {
            builder.append("All available accounts without balances.\n");
        } else if (AisAccountAccessTypeBO.ALL_ACCOUNTS_WITH_BALANCES.equals((Object)access.getAvailableAccounts())) {
            builder.append("All available accounts with balances and transactions.\n");
        }
        this.format(builder, access.getAccounts(), "Without balances: %s.\n");
        this.format(builder, access.getBalances(), "With balances: %s.\n");
        this.format(builder, access.getTransactions(), "With balances and transactions: %s.\n");
        return builder;
    }

    private void format(StringBuilder b, List<String> list, String template) {
        if (CollectionUtils.isNotEmpty(list)) {
            b.append(String.format(template, String.join((CharSequence)" ", list)));
        }
    }

    private void checkNullConsent() {
        if (this.consent == null) {
            throw new IllegalStateException("Not expecting consent to be null.");
        }
        if (StringUtils.isEmpty((CharSequence)this.consent.getTppId())) {
            throw new IllegalStateException("Not expecting tppId to be null.");
        }
    }

    public ConsentMessageHelper(AisConsentBO consent) {
        this.consent = consent;
    }
}

