/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.message.step;

import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.middleware.api.domain.general.StepOperation;
import de.adorsys.ledgers.middleware.impl.service.message.step.BaseStepMessageHandler;
import de.adorsys.ledgers.middleware.impl.service.message.step.ConsentMessageHelper;
import de.adorsys.ledgers.middleware.impl.service.message.step.PaymentMessageHelper;
import de.adorsys.ledgers.middleware.impl.service.message.step.StepMessageHandlerRequest;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import de.adorsys.ledgers.um.api.service.UserService;
import org.springframework.stereotype.Component;

@Component
public class ConfirmationAuthCodeStepMessageHandler
extends BaseStepMessageHandler {
    private final DepositAccountPaymentService paymentService;
    private final UserService userService;

    @Override
    public String message(StepMessageHandlerRequest request) {
        SCAOperationBO scaOperation = request.getScaOperation();
        String template = this.resolveOperationTemplate(scaOperation.getOpType(), scaOperation.getOpId());
        return this.updateMessage(template, request);
    }

    @Override
    public StepOperation getStepOperation() {
        return StepOperation.CONFIRM_AUTH_CODE;
    }

    private String resolveOperationTemplate(OpTypeBO opType, String oprId) {
        if (opType == OpTypeBO.CONSENT) {
            AisConsentBO aisConsentBO = this.userService.loadConsent(oprId);
            return new ConsentMessageHelper(aisConsentBO).template();
        }
        PaymentBO payment = this.paymentService.getPaymentById(oprId);
        return new PaymentMessageHelper(oprId, opType, payment.getPaymentType()).getTanTemplate();
    }

    public ConfirmationAuthCodeStepMessageHandler(DepositAccountPaymentService paymentService, UserService userService) {
        this.paymentService = paymentService;
        this.userService = userService;
    }
}

