/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.message;

import de.adorsys.ledgers.middleware.api.domain.general.StepOperation;
import de.adorsys.ledgers.middleware.impl.service.message.PsuMessageResolver;
import de.adorsys.ledgers.middleware.impl.service.message.step.StepMessageHandler;
import de.adorsys.ledgers.middleware.impl.service.message.step.StepMessageHandlerRequest;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class PsuMessageResolverImpl
implements PsuMessageResolver {
    private final List<StepMessageHandler> stepMessageHandlers;

    @Override
    public String message(StepOperation stepOperation, SCAOperationBO operation) {
        return this.getMessageHandler(stepOperation).message(StepMessageHandlerRequest.builder().scaOperation(operation).opType(operation.getOpType()).build());
    }

    @Override
    public String message(StepOperation stepOperation, SCAOperationBO operation, Object operationObject) {
        return this.getMessageHandler(stepOperation).message(StepMessageHandlerRequest.builder().scaOperation(operation).opType(operation.getOpType()).operationObject(operationObject).build());
    }

    @Override
    public String message(StepOperation stepOperation, OpTypeBO opType, boolean isScaRequired, Object operationObject) {
        return this.getMessageHandler(stepOperation).message(StepMessageHandlerRequest.builder().opType(opType).isScaRequired(isScaRequired).operationObject(operationObject).build());
    }

    StepMessageHandler getMessageHandler(StepOperation stepOperation) {
        return this.stepMessageHandlers.stream().filter(so -> so.getStepOperation() == stepOperation).findFirst().orElseThrow(() -> new IllegalArgumentException(stepOperation + " step operation not supported."));
    }

    public PsuMessageResolverImpl(List<StepMessageHandler> stepMessageHandlers) {
        this.stepMessageHandlers = stepMessageHandlers;
    }
}

