/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.middleware.api.domain.general.StepOperation;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.OperationService;
import de.adorsys.ledgers.middleware.impl.config.PaymentValidatorService;
import de.adorsys.ledgers.middleware.impl.converter.AisConsentBOMapper;
import de.adorsys.ledgers.middleware.impl.converter.PaymentConverter;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.middleware.impl.policies.PaymentCancelPolicy;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.middleware.impl.service.SCAUtils;
import de.adorsys.ledgers.middleware.impl.service.message.PsuMessageResolver;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.UserService;
import java.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OperationServiceImpl
implements OperationService {
    private static final Logger log = LoggerFactory.getLogger(OperationServiceImpl.class);
    private final DepositAccountPaymentService paymentService;
    private final PaymentConverter paymentConverter;
    private final SCAUtils scaUtils;
    private final AccessService accessService;
    private final UserMapper userMapper;
    private final UserService userService;
    private final AisConsentBOMapper aisConsentMapper;
    private final SCAOperationService scaOperationService;
    private final PaymentValidatorService paymentValidator;
    private final PsuMessageResolver messageResolver;
    @Value(value="${ledgers.sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public <T> GlobalScaResponseTO resolveInitiation(OpTypeTO opType, String opId, T object, ScaInfoTO scaInfo) {
        int scaWeight;
        UserBO user = this.scaUtils.userBO(scaInfo.getUserLogin());
        GlobalScaResponseTO response = this.resolveBasicResponse(false, opType, user, scaInfo);
        if (OpTypeTO.CONSENT == opType) {
            AisConsentBO consent = this.aisConsentMapper.toAisConsentBO((AisConsentTO)object);
            scaWeight = user.resolveMinimalWeightForIbanSet(consent.getUniqueIbans());
            consent = this.userService.storeConsent(consent);
            response.setOperationObjectId(consent.getId());
        } else {
            scaWeight = this.resolveForPmtType(opType, opId, (PaymentTO)object, user, response);
        }
        response.setMultilevelScaRequired(this.multilevelScaEnable && scaWeight < 100);
        return response;
    }

    public GlobalScaResponseTO execute(OpTypeTO opType, String opId, ScaInfoTO scaInfo) {
        if (opType == OpTypeTO.CONSENT) {
            throw MiddlewareModuleException.builder().devMsg("Consent execution not supported").errorCode(MiddlewareErrorCode.UNSUPPORTED_OPERATION).build();
        }
        PaymentBO payment = this.paymentService.getPaymentById(opId);
        OpTypeBO opTypeBO = OpTypeBO.valueOf((String)opType.name());
        boolean authenticationCompleted = this.scaOperationService.authenticationCompleted(opId, opTypeBO);
        UserBO user = this.scaUtils.userBO(scaInfo.getUserLogin());
        GlobalScaResponseTO response = this.resolveBasicResponse(true, opType, user, scaInfo);
        if (authenticationCompleted) {
            this.performExecuteOrCancelOperation(scaInfo, opId, opTypeBO, payment);
        } else if (this.multilevelScaEnable) {
            payment.setTransactionStatus(this.paymentService.updatePaymentStatus(opId, TransactionStatusBO.PATC));
            response.setMultilevelScaRequired(true);
            response.setPartiallyAuthorised(true);
        }
        response.setOperationObjectId(payment.getPaymentId());
        response.setTransactionStatus(TransactionStatusTO.valueOf((String)payment.getTransactionStatus().name()));
        return response;
    }

    private void performExecuteOrCancelOperation(ScaInfoTO scaInfoTO, String paymentId, OpTypeBO opType, PaymentBO payment) {
        if (opType == OpTypeBO.PAYMENT) {
            this.paymentService.updatePaymentStatus(paymentId, TransactionStatusBO.ACTC);
            payment.setTransactionStatus(this.paymentService.executePayment(paymentId, scaInfoTO.getUserLogin()));
        } else {
            payment.setTransactionStatus(this.paymentService.cancelPayment(paymentId));
        }
    }

    private int resolveForPmtType(OpTypeTO opType, String opId, PaymentTO object, UserBO user, GlobalScaResponseTO response) {
        PaymentBO payment;
        if (OpTypeTO.PAYMENT == opType) {
            payment = this.paymentConverter.toPaymentBO(object);
            this.paymentValidator.validate(payment, user);
            TransactionStatusBO status = user.hasSCA() ? TransactionStatusBO.ACCP : TransactionStatusBO.ACTC;
            payment = this.paymentService.initiatePayment(payment, status);
        } else {
            payment = this.paymentService.getPaymentById(opId);
            payment.setRequestedExecutionTime(LocalTime.now().plusMinutes(10L));
            PaymentCancelPolicy.onCancel(opId, payment.getTransactionStatus());
        }
        response.setOperationObjectId(payment.getPaymentId());
        response.setTransactionStatus(TransactionStatusTO.valueOf((String)payment.getTransactionStatus().name()));
        return user.resolveWeightForAccount(payment.getAccountId());
    }

    private GlobalScaResponseTO resolveBasicResponse(boolean isFinal, OpTypeTO opType, UserBO user, ScaInfoTO scaInfo) {
        String psuMessage = this.messageResolver.message(StepOperation.INITIATION, new SCAOperationBO());
        if (isFinal) {
            return new GlobalScaResponseTO(opType, null, ScaStatusTO.FINALISED, this.userMapper.toScaUserDataListTO(user.getScaUserData()), psuMessage);
        }
        boolean isScaRequired = user.hasSCA();
        BearerTokenTO token = this.accessService.exchangeTokenStartSca(isScaRequired, scaInfo.getAccessToken());
        ScaStatusTO scaStatus = isScaRequired ? ScaStatusTO.PSUAUTHENTICATED : ScaStatusTO.EXEMPTED;
        return new GlobalScaResponseTO(opType, token, scaStatus, this.userMapper.toScaUserDataListTO(user.getScaUserData()), psuMessage);
    }

    public OperationServiceImpl(DepositAccountPaymentService paymentService, PaymentConverter paymentConverter, SCAUtils scaUtils, AccessService accessService, UserMapper userMapper, UserService userService, AisConsentBOMapper aisConsentMapper, SCAOperationService scaOperationService, PaymentValidatorService paymentValidator, PsuMessageResolver messageResolver) {
        this.paymentService = paymentService;
        this.paymentConverter = paymentConverter;
        this.scaUtils = scaUtils;
        this.accessService = accessService;
        this.userMapper = userMapper;
        this.userService = userService;
        this.aisConsentMapper = aisConsentMapper;
        this.scaOperationService = scaOperationService;
        this.paymentValidator = paymentValidator;
        this.messageResolver = messageResolver;
    }
}

