/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.keycloak.client.api.KeycloakDataService;
import de.adorsys.ledgers.keycloak.client.model.KeycloakUser;
import de.adorsys.ledgers.middleware.api.domain.account.AccountIdentifierTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AdditionalAccountInformationTO;
import de.adorsys.ledgers.middleware.api.domain.general.RecoveryPointTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareRecoveryService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.impl.converter.AdditionalAccountInformationMapper;
import de.adorsys.ledgers.middleware.impl.converter.KeycloakUserMapper;
import de.adorsys.ledgers.middleware.impl.converter.PageMapper;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.um.api.domain.AccountAccessBO;
import de.adorsys.ledgers.um.api.domain.AccountIdentifierTypeBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.ledgers.util.domain.CustomPageableImpl;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewareUserManagementServiceImpl
implements MiddlewareUserManagementService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewareUserManagementServiceImpl.class);
    private static final int NANO_TO_SECOND = 1000000000;
    private final UserService userService;
    private final DepositAccountService depositAccountService;
    private final AccessService accessService;
    private final UserMapper userTOMapper = (UserMapper)Mappers.getMapper(UserMapper.class);
    private final PageMapper pageMapper;
    private final AdditionalAccountInformationMapper additionalInfoMapper;
    private final MiddlewareRecoveryService recoveryService;
    private final KeycloakDataService dataService;
    private final KeycloakUserMapper keycloakUserMapper;
    private final KeycloakDataService keycloakDataService;
    @Value(value="${ledgers.sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;
    @Value(value="${ledgers.sca.final.weight:100}")
    private int finalWeight;

    @Transactional
    public UserTO create(UserTO user) {
        UserBO createdUser = this.userService.create(this.userTOMapper.toUserBO(user));
        try {
            KeycloakUser keycloakUser = this.keycloakUserMapper.toKeycloakUser(createdUser, user.getPin());
            this.dataService.createUser(keycloakUser);
        }
        catch (Exception e) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg(String.format("Could not register user at IDP msg: %s", e.getMessage())).build();
        }
        if (createdUser.getUserRoles().contains(UserRoleBO.STAFF)) {
            RecoveryPointTO point = new RecoveryPointTO(String.format("Registered %s user", user.getLogin()));
            this.recoveryService.createRecoveryPoint(createdUser.getBranch(), point);
        }
        return this.userTOMapper.toUserTO(createdUser);
    }

    public UserTO findById(String id) {
        return this.userTOMapper.toUserTO(this.userService.findById(id));
    }

    public UserTO findByUserLogin(String userLogin) {
        return this.userTOMapper.toUserTO(this.userService.findByLogin(userLogin));
    }

    public UserTO updateScaData(String userLogin, List<ScaUserDataTO> scaDataList) {
        UserBO userBO = this.userService.updateScaData(this.userTOMapper.toScaUserDataListBO(scaDataList), userLogin);
        return this.userTOMapper.toUserTO(userBO);
    }

    public void updateAccountAccess(ScaInfoTO scaInfo, String userId, AccountAccessTO access) {
        UserTO user = this.findById(userId);
        DepositAccountBO account = this.depositAccountService.getAccountById(access.getAccountId());
        this.accessService.updateAccountAccessNewAccount(account, this.userTOMapper.toUserBO(user), access.getScaWeight(), access.getAccessType());
    }

    public List<UserTO> listUsers(int page, int size) {
        long start = System.nanoTime();
        List<UserTO> users = this.userTOMapper.toUserTOList(this.userService.listUsers(page, size));
        log.info("Retrieving: {} users in {} seconds", (Object)users.size(), (Object)((double)(System.nanoTime() - start) / 1.0E9));
        return users;
    }

    public CustomPageImpl<UserTO> getUsersByBranchAndRoles(String countryCode, String branchId, String branchLogin, String userLogin, List<UserRoleTO> roles, Boolean blocked, CustomPageableImpl pageable) {
        return this.pageMapper.toCustomPageImpl(this.userService.findUsersByMultipleParamsPaged(countryCode, branchId, branchLogin, userLogin, this.userTOMapper.toUserRoleBO(roles), blocked, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.userTOMapper::toUserTO));
    }

    public List<String> getBranchUserLogins(String branchId) {
        return this.userService.findUserLoginsByBranch(branchId);
    }

    public CustomPageImpl<UserTO> getUsersByRoles(List<UserRoleTO> roles, CustomPageableImpl pageable) {
        Page users = this.userService.getUsersByRoles(this.userTOMapper.toUserRoleBO(roles), (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize()));
        Page map = users.map(this.userTOMapper::toUserTO);
        return this.pageMapper.toCustomPageImpl(map);
    }

    public CustomPageImpl<UserExtendedTO> getUsersByBranchAndRolesExtended(String countryCode, String branchId, String branchLogin, String userLogin, List<UserRoleTO> roles, Boolean blocked, CustomPageableImpl pageable) {
        return this.pageMapper.toCustomPageImpl(this.userService.findUsersByMultipleParamsPaged(countryCode, branchId, branchLogin, userLogin, this.userTOMapper.toUserRoleBO(roles), blocked, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.userTOMapper::toUserExtendedTO));
    }

    public int countUsersByBranch(String branch) {
        return this.userService.countUsersByBranch(branch);
    }

    public UserTO updateUser(String branchId, UserTO user) {
        String userId = Optional.ofNullable(user.getId()).orElseThrow(() -> MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.REQUEST_VALIDATION_FAILURE).devMsg("User id is not present in request!").build());
        UserBO userFromLedgers = this.userService.findById(userId);
        UserBO userBO = this.userTOMapper.toUserBO(user);
        this.dataService.updateUser(this.keycloakUserMapper.toKeycloakUser(userBO), userFromLedgers.getLogin());
        this.updatePasswordByLogin(userFromLedgers.getLogin(), user.getPin());
        return this.userTOMapper.toUserTO(this.userService.updateUser(userBO));
    }

    public void updatePasswordById(String userId, String password) {
        String login = this.userService.findById(userId).getLogin();
        this.updatePasswordByLogin(login, password);
    }

    public void updatePasswordByLogin(String login, String password) {
        if (StringUtils.isNotBlank((CharSequence)password)) {
            this.dataService.resetPassword(login, password);
        }
    }

    public boolean checkMultilevelScaRequired(String login, String iban) {
        if (!this.multilevelScaEnable) {
            return false;
        }
        return this.userService.findByLogin(login).resolveScaWeightByIban(iban) < this.finalWeight;
    }

    public boolean checkMultilevelScaRequired(String login, List<AccountReferenceTO> references) {
        if (!this.multilevelScaEnable) {
            return false;
        }
        UserBO user = this.userService.findByLogin(login);
        if (CollectionUtils.isEmpty(references)) {
            return user.getAccountAccesses().stream().anyMatch(a -> a.getScaWeight() < this.finalWeight);
        }
        List<AccountAccessBO> accountAccessBOS = this.userTOMapper.toAccountAccessFromReferenceList(references);
        return user.resolveMinimalWeightForReferences(accountAccessBOS) < this.finalWeight;
    }

    public List<AdditionalAccountInformationTO> getAdditionalInformation(ScaInfoTO scaInfoHolder, AccountIdentifierTypeTO accountIdentifierType, String accountIdentifier) {
        List info = AccountIdentifierTypeBO.valueOf((String)accountIdentifierType.name()).getAdditionalAccountInfo(accountIdentifier, arg_0 -> ((UserService)this.userService).findOwnersByIban(arg_0), arg_0 -> ((UserService)this.userService).findOwnersByAccountId(arg_0));
        return this.additionalInfoMapper.toAdditionalAccountInformationTOs(info);
    }

    public boolean changeStatus(String userId, boolean isSystemBlock) {
        UserBO user = this.userService.findById(userId);
        boolean lockStatusToSet = isSystemBlock ? !user.isSystemBlocked() : !user.isBlocked();
        this.userService.setUserBlockedStatus(userId, isSystemBlock, lockStatusToSet);
        this.depositAccountService.changeAccountsBlockedStatus(user.getAccountIds(), isSystemBlock, lockStatusToSet);
        return lockStatusToSet;
    }

    public void editBasicSelf(String userId, UserTO user) {
        UserBO storedUser = this.userService.findById(userId);
        storedUser.setLogin(user.getLogin());
        storedUser.setEmail(user.getEmail());
        storedUser.setPin(user.getPin());
        this.userService.updateUser(storedUser);
        this.dataService.updateUser(this.keycloakUserMapper.toKeycloakUser(storedUser), storedUser.getLogin());
        this.updatePasswordByLogin(storedUser.getLogin(), user.getPin());
    }

    public void resetPasswordViaEmail(String login) {
        this.keycloakDataService.resetPasswordViaEmail(login);
        log.info("Link for password reset was sent to user [{}] email", (Object)login);
    }

    public String findAccountOwner(String accountId) {
        return ((UserBO)this.userService.findOwnersByAccountId(accountId).iterator().next()).getLogin();
    }

    public MiddlewareUserManagementServiceImpl(UserService userService, DepositAccountService depositAccountService, AccessService accessService, PageMapper pageMapper, AdditionalAccountInformationMapper additionalInfoMapper, MiddlewareRecoveryService recoveryService, KeycloakDataService dataService, KeycloakUserMapper keycloakUserMapper, KeycloakDataService keycloakDataService) {
        this.userService = userService;
        this.depositAccountService = depositAccountService;
        this.accessService = accessService;
        this.pageMapper = pageMapper;
        this.additionalInfoMapper = additionalInfoMapper;
        this.recoveryService = recoveryService;
        this.dataService = dataService;
        this.keycloakUserMapper = keycloakUserMapper;
        this.keycloakDataService = keycloakDataService;
    }
}

