/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.middleware.api.domain.general.StepOperation;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.StartScaOprTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareRedirectScaService;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.ScaResponseConverter;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.middleware.impl.service.message.PsuMessageResolver;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.domain.ScaValidationBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.BearerTokenBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.UserService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MiddlewareRedirectScaServiceImpl
implements MiddlewareRedirectScaService {
    private static final String NO_USER_MESSAGE = "No user message";
    @Value(value="${ledgers.sca.authCode.validity.seconds:180}")
    private int authCodeLifetime;
    private final UserService userService;
    private final DepositAccountPaymentService paymentService;
    private final SCAOperationService scaOperationService;
    private final ScaResponseConverter scaResponseConverter;
    private final AccessService accessService;
    private final BearerTokenMapper bearerTokenMapper;
    private final PsuMessageResolver messageResolver;

    public GlobalScaResponseTO startScaOperation(StartScaOprTO scaOpr, ScaInfoTO scaInfo) {
        UserBO user = this.userService.findByLogin(scaInfo.getUserLogin());
        if (!user.hasSCA()) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.SCA_UNAVAILABLE).devMsg("Sorry, but do not have any SCA Methods configured!").build();
        }
        OpTypeBO opType = OpTypeBO.valueOf((String)scaOpr.getOpType().name());
        int scaWeight = this.resolveWeightForOperation(opType, scaOpr.getOprId(), user);
        AuthCodeDataBO codeData = new AuthCodeDataBO(user.getLogin(), null, scaOpr.getOprId(), scaOpr.getExternalId(), NO_USER_MESSAGE, this.authCodeLifetime, opType, scaOpr.getAuthorisationId(), scaWeight);
        SCAOperationBO operation = this.scaOperationService.checkIfExistsOrNew(codeData);
        String psuMessage = this.messageResolver.message(StepOperation.START_SCA, operation);
        BearerTokenBO bearerToken = this.bearerTokenMapper.toBearerTokenBO(scaInfo.getBearerToken());
        return this.scaResponseConverter.mapResponse(operation, user.getScaUserData(), psuMessage, bearerToken, scaWeight, null);
    }

    public GlobalScaResponseTO getMethods(String authorizationId, ScaInfoTO scaInfo) {
        UserBO user = this.userService.findByLogin(scaInfo.getUserLogin());
        SCAOperationBO operation = this.scaOperationService.loadAuthCode(authorizationId);
        String psuMessage = this.messageResolver.message(StepOperation.GET_SCA_METHODS, operation);
        return this.scaResponseConverter.mapResponse(operation, user.getScaUserData(), psuMessage, this.bearerTokenMapper.toBearerTokenBO(scaInfo.getBearerToken()), 0, null);
    }

    public GlobalScaResponseTO selectMethod(ScaInfoTO scaInfo) {
        SCAOperationBO operation = this.scaOperationService.loadAuthCode(scaInfo.getAuthorisationId());
        UserBO user = this.userService.findByLogin(scaInfo.getUserLogin());
        int scaWeight = this.resolveWeightForOperation(operation.getOpType(), operation.getOpId(), user);
        AuthCodeDataBO data = new AuthCodeDataBO(user.getLogin(), scaInfo.getScaMethodId(), operation.getOpId(), null, "", this.authCodeLifetime, operation.getOpType(), operation.getId(), scaWeight);
        operation = this.scaOperationService.generateAuthCode(data, user, ScaStatusBO.SCAMETHODSELECTED);
        return this.scaResponseConverter.mapResponse(operation, user.getScaUserData(), this.messageResolver.message(StepOperation.SELECT_SCA_METHOD, operation), this.bearerTokenMapper.toBearerTokenBO(scaInfo.getBearerToken()), scaWeight, null);
    }

    public GlobalScaResponseTO confirmAuthorization(ScaInfoTO scaInfo) {
        SCAOperationBO operation = this.scaOperationService.loadAuthCode(scaInfo.getAuthorisationId());
        UserBO user = this.userService.findByLogin(scaInfo.getUserLogin());
        int scaWeight = this.resolveWeightForOperation(operation.getOpType(), operation.getOpId(), user);
        ScaValidationBO scaValidation = this.scaOperationService.validateAuthCode(scaInfo.getAuthorisationId(), operation.getOpId(), scaInfo.getAuthCode(), scaWeight);
        operation.setScaStatus(scaValidation.getScaStatus());
        boolean authenticationCompleted = this.scaOperationService.authenticationCompleted(operation.getOpId(), operation.getOpType());
        String psuMessage = this.messageResolver.message(StepOperation.CONFIRM_AUTH_CODE, operation);
        BearerTokenTO exchangeToken = this.accessService.exchangeTokenEndSca(authenticationCompleted, scaInfo.getAccessToken());
        return this.scaResponseConverter.mapResponse(operation, user.getScaUserData(), psuMessage, this.bearerTokenMapper.toBearerTokenBO(exchangeToken), scaWeight, scaValidation.getAuthConfirmationCode());
    }

    public StartScaOprTO loadScaInformation(String authorizationId) {
        SCAOperationBO operation = this.scaOperationService.loadAuthCode(authorizationId);
        return new StartScaOprTO(operation.getOpId(), OpTypeTO.valueOf((String)operation.getOpType().name()));
    }

    private int resolveWeightForOperation(OpTypeBO opType, String oprId, UserBO user) {
        return opType == OpTypeBO.CONSENT ? user.resolveMinimalWeightForIbanSet(this.userService.loadConsent(oprId).getUniqueIbans()) : user.resolveWeightForAccount(this.paymentService.getPaymentById(oprId).getAccountId());
    }

    public MiddlewareRedirectScaServiceImpl(UserService userService, DepositAccountPaymentService paymentService, SCAOperationService scaOperationService, ScaResponseConverter scaResponseConverter, AccessService accessService, BearerTokenMapper bearerTokenMapper, PsuMessageResolver messageResolver) {
        this.userService = userService;
        this.paymentService = paymentService;
        this.scaOperationService = scaOperationService;
        this.scaResponseConverter = scaResponseConverter;
        this.accessService = accessService;
        this.bearerTokenMapper = bearerTokenMapper;
        this.messageResolver = messageResolver;
    }
}

