/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.middleware.api.domain.general.StepOperation;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.impl.config.PaymentValidatorService;
import de.adorsys.ledgers.middleware.impl.converter.PageMapper;
import de.adorsys.ledgers.middleware.impl.converter.PaymentConverter;
import de.adorsys.ledgers.middleware.impl.converter.ScaResponseResolver;
import de.adorsys.ledgers.middleware.impl.policies.PaymentCancelPolicy;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.middleware.impl.service.SCAUtils;
import de.adorsys.ledgers.middleware.impl.service.message.PsuMessageResolver;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.ledgers.util.domain.CustomPageableImpl;
import de.adorsys.ledgers.util.exception.ScaModuleException;
import java.time.LocalTime;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewarePaymentServiceImpl
implements MiddlewarePaymentService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewarePaymentServiceImpl.class);
    private final DepositAccountPaymentService paymentService;
    private final SCAOperationService scaOperationService;
    private final PaymentConverter paymentConverter;
    private final SCAUtils scaUtils;
    private final AccessService accessService;
    private final ScaResponseResolver scaResponseResolver;
    private final PageMapper pageMapper;
    private final PaymentValidatorService paymentValidator;
    private final PsuMessageResolver messageResolver;
    @Value(value="${ledgers.sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public TransactionStatusTO getPaymentStatusById(String paymentId) {
        TransactionStatusBO paymentStatus = this.paymentService.getPaymentStatusById(paymentId);
        return TransactionStatusTO.valueOf((String)paymentStatus.name());
    }

    public SCAPaymentResponseTO initiatePaymentCancellation(ScaInfoTO scaInfoTO, String paymentId) {
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserLogin());
        PaymentBO payment = this.paymentService.getPaymentById(paymentId);
        payment.setRequestedExecutionTime(LocalTime.now().plusMinutes(10L));
        PaymentCancelPolicy.onCancel(paymentId, payment.getTransactionStatus());
        return this.prepareScaAndResolveResponse(scaInfoTO, payment, userBO, OpTypeBO.CANCEL_PAYMENT);
    }

    public SCAPaymentResponseTO initiatePayment(ScaInfoTO scaInfoTO, PaymentTO payment) {
        PaymentBO paymentBO = this.paymentConverter.toPaymentBO(payment);
        UserBO user = this.scaUtils.userBO(scaInfoTO.getUserLogin());
        this.paymentValidator.validate(paymentBO, user);
        TransactionStatusBO status = user.hasSCA() ? TransactionStatusBO.ACCP : TransactionStatusBO.ACTC;
        return this.prepareScaAndResolveResponse(scaInfoTO, this.paymentService.initiatePayment(paymentBO, status), user, OpTypeBO.PAYMENT);
    }

    public SCAPaymentResponseTO executePayment(ScaInfoTO scaInfoTO, String paymentId) {
        PaymentBO payment = this.paymentService.getPaymentById(paymentId);
        TransactionStatusBO status = this.paymentService.updatePaymentStatus(paymentId, scaInfoTO.hasScope("full_access") ? TransactionStatusBO.ACTC : TransactionStatusBO.PATC);
        if (status == TransactionStatusBO.ACTC) {
            status = this.paymentService.executePayment(payment.getPaymentId(), scaInfoTO.getUserLogin());
        }
        return new SCAPaymentResponseTO(payment.getPaymentId(), status.name(), payment.getPaymentType().name(), payment.getPaymentProduct());
    }

    private SCAPaymentResponseTO prepareScaAndResolveResponse(ScaInfoTO scaInfoTO, PaymentBO payment, UserBO user, OpTypeBO opType) {
        boolean isScaRequired = user.hasSCA();
        String psuMessage = this.messageResolver.message(StepOperation.INITIATE_OPERATION_OBJECT, opType, isScaRequired, payment);
        BearerTokenTO token = this.accessService.exchangeTokenStartSca(isScaRequired, scaInfoTO.getAccessToken());
        ScaStatusTO scaStatus = isScaRequired ? ScaStatusTO.PSUAUTHENTICATED : ScaStatusTO.EXEMPTED;
        int scaWeight = user.resolveWeightForAccount(payment.getAccountId());
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        this.scaResponseResolver.updateScaResponseFields(user, response, null, psuMessage, token, scaStatus, scaWeight);
        return this.scaResponseResolver.updatePaymentRelatedResponseFields(response, payment);
    }

    public PaymentTO getPaymentById(String paymentId) {
        PaymentBO paymentResult = this.paymentService.getPaymentById(paymentId);
        return this.paymentConverter.toPaymentTO(paymentResult);
    }

    @Transactional(noRollbackFor={ScaModuleException.class})
    public SCAPaymentResponseTO authorizePayment(ScaInfoTO scaInfoTO, String paymentId) {
        return this.authorizeOperation(scaInfoTO, paymentId, OpTypeBO.PAYMENT);
    }

    @Transactional(noRollbackFor={ScaModuleException.class})
    public SCAPaymentResponseTO authorizeCancelPayment(ScaInfoTO scaInfoTO, String paymentId) {
        return this.authorizeOperation(scaInfoTO, paymentId, OpTypeBO.CANCEL_PAYMENT);
    }

    public List<PaymentTO> getPendingPeriodicPayments(ScaInfoTO scaInfoTO) {
        Set accountIds = this.scaUtils.userBO(scaInfoTO.getUserLogin()).getAccountIds();
        List payments = this.paymentService.getPaymentsByTypeStatusAndDebtor(PaymentTypeBO.PERIODIC, TransactionStatusBO.ACSP, accountIds);
        return this.paymentConverter.toPaymentTOList(payments);
    }

    public CustomPageImpl<PaymentTO> getPendingPeriodicPaymentsPaged(ScaInfoTO scaInfo, CustomPageableImpl pageable) {
        Set accountIds = this.scaUtils.userBO(scaInfo.getUserLogin()).getAccountIds();
        return this.pageMapper.toCustomPageImpl(this.paymentService.getPaymentsByTypeStatusAndDebtorPaged(PaymentTypeBO.PERIODIC, TransactionStatusBO.ACSP, accountIds, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.paymentConverter::toPaymentTO));
    }

    public CustomPageImpl<PaymentTO> getAllPaymentsPaged(ScaInfoTO scaInfo, CustomPageableImpl pageable) {
        Set<PaymentTypeBO> paymentType = Set.of(PaymentTypeBO.PERIODIC, PaymentTypeBO.SINGLE, PaymentTypeBO.BULK);
        Set<TransactionStatusBO> status = Set.of(TransactionStatusBO.values());
        Set accountIds = this.scaUtils.userBO(scaInfo.getUserLogin()).getAccountIds();
        return this.pageMapper.toCustomPageImpl(this.paymentService.getPaymentsByTypeStatusAndDebtorInPaged(paymentType, status, accountIds, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.paymentConverter::toPaymentTO));
    }

    private SCAPaymentResponseTO authorizeOperation(ScaInfoTO scaInfoTO, String paymentId, OpTypeBO opType) {
        PaymentBO payment = this.paymentService.getPaymentById(paymentId);
        if (this.scaOperationService.authenticationCompleted(paymentId, opType)) {
            this.performExecuteOrCancelOperation(scaInfoTO, paymentId, opType, payment);
        } else if (this.multilevelScaEnable) {
            payment.setTransactionStatus(this.paymentService.updatePaymentStatus(paymentId, TransactionStatusBO.PATC));
        }
        UserBO user = this.scaUtils.userBO(scaInfoTO.getUserLogin());
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        int scaWeight = user.resolveWeightForAccount(payment.getAccountId());
        String psuMessage = this.messageResolver.message(StepOperation.AUTHORIZE, opType, true, payment);
        this.scaResponseResolver.updateScaResponseFields(user, new SCAPaymentResponseTO(), null, psuMessage, null, ScaStatusTO.FINALISED, scaWeight);
        return this.scaResponseResolver.updatePaymentRelatedResponseFields(response, payment);
    }

    private void performExecuteOrCancelOperation(ScaInfoTO scaInfoTO, String paymentId, OpTypeBO opType, PaymentBO payment) {
        if (opType == OpTypeBO.PAYMENT) {
            this.paymentService.updatePaymentStatus(paymentId, TransactionStatusBO.ACTC);
            payment.setTransactionStatus(this.paymentService.executePayment(paymentId, scaInfoTO.getUserLogin()));
        } else {
            payment.setTransactionStatus(this.paymentService.cancelPayment(paymentId));
        }
    }

    public MiddlewarePaymentServiceImpl(DepositAccountPaymentService paymentService, SCAOperationService scaOperationService, PaymentConverter paymentConverter, SCAUtils scaUtils, AccessService accessService, ScaResponseResolver scaResponseResolver, PageMapper pageMapper, PaymentValidatorService paymentValidator, PsuMessageResolver messageResolver) {
        this.paymentService = paymentService;
        this.scaOperationService = scaOperationService;
        this.paymentConverter = paymentConverter;
        this.scaUtils = scaUtils;
        this.accessService = accessService;
        this.scaResponseResolver = scaResponseResolver;
        this.pageMapper = pageMapper;
        this.paymentValidator = paymentValidator;
        this.messageResolver = messageResolver;
    }
}

