/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.oauth.OauthCodeResponseTO;
import de.adorsys.ledgers.middleware.api.domain.oauth.OauthServerInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareOauthService;
import de.adorsys.ledgers.middleware.impl.converter.OauthServerInfoMapper;
import de.adorsys.ledgers.um.api.domain.oauth.OauthCodeResponseBO;
import de.adorsys.ledgers.um.api.domain.oauth.OauthTokenHolder;
import de.adorsys.ledgers.um.api.service.OauthAuthorisationService;
import de.adorsys.ledgers.um.api.service.UserService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MiddlewareOauthServiceImpl
implements MiddlewareOauthService {
    private final OauthAuthorisationService oauthAuthorisationService;
    private final OauthServerInfoMapper oauthServerInfoMapper;
    private final KeycloakTokenService tokenService;
    private final UserService userService;
    @Value(value="${ledgers.token.lifetime.seconds.full:7776000}")
    private int fullTokenLifeTime;

    public OauthCodeResponseTO oauthCode(String login, String pin, String redirectUri) {
        BearerTokenTO token = this.tokenService.login(login, pin);
        String userId = this.userService.findByLogin(login).getId();
        OauthCodeResponseBO response = this.oauthAuthorisationService.oauthCode(userId, token.getAccess_token(), false);
        return new OauthCodeResponseTO(redirectUri, response.getCode());
    }

    public OauthCodeResponseTO oauthCode(ScaInfoTO scaInfo, String redirectUri) {
        OauthCodeResponseBO response = this.oauthAuthorisationService.oauthCode(scaInfo.getUserId(), scaInfo.getAccessToken(), true);
        return new OauthCodeResponseTO(redirectUri, response.getCode());
    }

    public BearerTokenTO oauthToken(String code) {
        OauthTokenHolder holder = this.oauthAuthorisationService.oauthToken(code);
        return holder.isFinalStage() ? this.tokenService.exchangeToken(holder.getOldToken(), Integer.valueOf(this.fullTokenLifeTime), "full_access") : this.tokenService.validate(holder.getOldToken());
    }

    public OauthServerInfoTO oauthServerInfo() {
        return this.oauthServerInfoMapper.toOauthServerInfoTO(this.oauthAuthorisationService.oauthServerInfo());
    }

    public MiddlewareOauthServiceImpl(OauthAuthorisationService oauthAuthorisationService, OauthServerInfoMapper oauthServerInfoMapper, KeycloakTokenService tokenService, UserService userService) {
        this.oauthAuthorisationService = oauthAuthorisationService;
        this.oauthServerInfoMapper = oauthServerInfoMapper;
        this.tokenService = tokenService;
        this.userService = userService;
    }
}

